/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.metrics.APMAgentReporter;
import com.networknt.metrics.AbstractMetricsHandler;
import com.networknt.metrics.MetricsConfig;
import com.networknt.server.Server;
import com.networknt.server.ServerConfig;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.dropwizard.metrics.Clock;
import io.dropwizard.metrics.MetricFilter;
import io.dropwizard.metrics.MetricName;
import io.dropwizard.metrics.MetricRegistry;
import io.dropwizard.metrics.broadcom.APMEPAgentSender;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APMMetricsHandler
extends AbstractMetricsHandler {
    static final Logger logger = LoggerFactory.getLogger(APMMetricsHandler.class);
    public static ServerConfig serverConfig;
    private boolean firstTime = true;
    private volatile HttpHandler next;

    public APMMetricsHandler() {
        config = MetricsConfig.load();
        if (config.getIssuerRegex() != null) {
            pattern = Pattern.compile(config.getIssuerRegex());
        }
        serverConfig = (ServerConfig)Config.getInstance().getJsonObjectConfig("server", ServerConfig.class);
        ModuleRegistry.registerModule(MetricsConfig.class.getName(), config.getMappedConfig(), null);
        if (logger.isDebugEnabled()) {
            logger.debug("APMMetricsHandler is constructed!");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.firstTime) {
            this.commonTags.put("api", Server.getServerConfig().getServiceId());
            this.commonTags.put("env", Server.getServerConfig().getEnvironment());
            this.commonTags.put("addr", Server.currentAddress);
            this.commonTags.put("port", "" + (Server.getServerConfig().isEnableHttps() ? Server.currentHttpsPort : Server.currentHttpPort));
            InetAddress inetAddress = Util.getInetAddress();
            this.commonTags.put("host", inetAddress == null ? "unknown" : inetAddress.getHostName());
            if (logger.isDebugEnabled()) {
                logger.debug(this.commonTags.toString());
            }
            try {
                APMEPAgentSender sender = new APMEPAgentSender(config.getServerProtocol(), config.getServerHost(), config.getServerPort(), config.getServerPath(), serverConfig.getServiceId(), config.getProductName());
                APMAgentReporter reporter = APMAgentReporter.forRegistry(registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(sender);
                reporter.start(config.getReportInMinutes(), TimeUnit.MINUTES);
                logger.info("apmmetrics is enabled and reporter is started");
            }
            catch (MalformedURLException e) {
                logger.error("apmmetrics has failed to initialize APMEPAgentSender", e);
            }
            this.firstTime = false;
        }
        long startTime = Clock.defaultClock().getTick();
        exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
            Map auditInfo = exchange1.getAttachment(AttachmentConstants.AUDIT_INFO);
            if (auditInfo != null) {
                String issuer;
                String clientId;
                HashMap<String, String> tags = new HashMap<String, String>();
                tags.put("endpoint", (String)auditInfo.get("endpoint"));
                String string = clientId = auditInfo.get("client_id") != null ? (String)auditInfo.get("client_id") : "unknown";
                if (logger.isTraceEnabled()) {
                    logger.trace("clientId = " + clientId);
                }
                tags.put("clientId", clientId);
                if (config.isSendScopeClientId()) {
                    tags.put("scopeClientId", auditInfo.get("scope_client_id") != null ? (String)auditInfo.get("scope_client_id") : "unknown");
                }
                if (config.isSendCallerId()) {
                    tags.put("callerId", auditInfo.get("caller_id") != null ? (String)auditInfo.get("caller_id") : "unknown");
                }
                if (config.isSendIssuer() && (issuer = (String)auditInfo.get("issuer_claims")) != null) {
                    if (config.getIssuerRegex() != null) {
                        Matcher matcher = pattern.matcher(issuer);
                        if (matcher.find()) {
                            String iss = matcher.group(1);
                            if (logger.isTraceEnabled()) {
                                logger.trace("Extracted issuer {} from Original issuer {] is sent.", (Object)iss, (Object)issuer);
                            }
                            tags.put("issuer", iss != null ? iss : "unknown");
                        }
                    } else {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Original issuer {} is sent.", (Object)issuer);
                        }
                        tags.put("issuer", issuer);
                    }
                }
                MetricName metricName = new MetricName("response_time");
                metricName = metricName.tagged(this.commonTags);
                metricName = metricName.tagged(tags);
                long time = Clock.defaultClock().getTick() - startTime;
                registry.getOrAdd(metricName, MetricRegistry.MetricBuilder.TIMERS).update(time, TimeUnit.NANOSECONDS);
                this.incCounterForStatusCode(exchange1.getStatusCode(), this.commonTags, tags);
            }
            nextListener.proceed();
        });
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(APMMetricsHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("handler"), null);
    }

    @Override
    public void reload() {
        config.reload();
        ModuleRegistry.registerModule(APMMetricsHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("handler"), null);
    }
}

