/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.Builder;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.OverlayFactory;
import com.networknt.jsonoverlay.ReferenceManager;
import com.networknt.jsonoverlay.ScalarOverlay;
import com.networknt.jsonoverlay.SerializationOptions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public final class NumberOverlay
extends ScalarOverlay<Number> {
    public static OverlayFactory<Number> factory = new OverlayFactory<Number>(){

        @Override
        protected Class<NumberOverlay> getOverlayClass() {
            return NumberOverlay.class;
        }

        public NumberOverlay _create(Number value, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new NumberOverlay(value, parent, refMgr);
        }

        public NumberOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new NumberOverlay(json, parent, refMgr);
        }
    };

    private NumberOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
    }

    private NumberOverlay(Number value, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(value, parent, factory, refMgr);
    }

    @Override
    protected Number _fromJson(JsonNode json) {
        if (json.isBigDecimal()) {
            return json.decimalValue();
        }
        if (json.isBigInteger()) {
            return json.bigIntegerValue();
        }
        if (json.isDouble()) {
            return json.doubleValue();
        }
        if (json.isFloat()) {
            return Float.valueOf(json.floatValue());
        }
        if (json.isInt()) {
            return json.intValue();
        }
        if (json.isLong()) {
            return json.longValue();
        }
        if (json.isShort()) {
            return json.shortValue();
        }
        return null;
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        if (this.value == null) {
            return NumberOverlay._jsonMissing();
        }
        NumberType type = NumberType.of((Number)this.value);
        if (type == null) {
            throw new IllegalArgumentException("Numeric class " + ((Number)this.value).getClass().getName() + " is not representable as a JsonNode");
        }
        switch (type) {
            case BigDecimal: {
                return NumberOverlay._jsonScalar((BigDecimal)this.value);
            }
            case BigInteger: {
                return NumberOverlay._jsonScalar((BigInteger)this.value);
            }
            case Byte: {
                return NumberOverlay._jsonScalar((Byte)this.value);
            }
            case Double: {
                return NumberOverlay._jsonScalar((Double)this.value);
            }
            case Float: {
                return NumberOverlay._jsonScalar(((Float)this.value).floatValue());
            }
            case Integer: {
                return NumberOverlay._jsonScalar((Integer)this.value);
            }
            case Long: {
                return NumberOverlay._jsonScalar((Long)this.value);
            }
            case Short: {
                return NumberOverlay._jsonScalar((Short)this.value);
            }
        }
        return NumberOverlay._jsonMissing();
    }

    @Override
    protected OverlayFactory<Number> _getFactory() {
        return factory;
    }

    public static Builder<Number> builder(JsonOverlay<?> modelMember) {
        return new Builder<Number>(factory, modelMember);
    }

    public static JsonOverlay<Number> create(JsonOverlay<?> modelMember) {
        return NumberOverlay.builder(modelMember).build();
    }

    public static JsonOverlay<Number> create(Number value, JsonOverlay<?> modelMember) {
        JsonOverlay<Number> result = NumberOverlay.create(modelMember);
        result._set(value);
        return result;
    }

    private static enum NumberType {
        BigDecimal(BigDecimal.class),
        BigInteger(BigInteger.class),
        Byte(Byte.class),
        Double(Double.class),
        Float(Float.class),
        Integer(Integer.class),
        Long(Long.class),
        Short(Short.class);

        private Class<? extends Number> cls;
        private static Map<Class<? extends Number>, NumberType> typeMap;

        private NumberType(Class<? extends Number> cls) {
            this.cls = cls;
        }

        private static <T extends Number> NumberType of(T obj) {
            if (typeMap == null) {
                NumberType.buildTypeMap();
            }
            return typeMap.get(obj.getClass());
        }

        private static void buildTypeMap() {
            typeMap = new HashMap<Class<? extends Number>, NumberType>();
            for (NumberType type : NumberType.values()) {
                typeMap.put(type.cls, type);
            }
        }

        static {
            typeMap = null;
        }
    }
}

