/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul;

import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulHeartbeatManager;
import com.networknt.consul.ConsulRecoveryManager;
import com.networknt.consul.ConsulResponse;
import com.networknt.consul.ConsulService;
import com.networknt.consul.ConsulUtils;
import com.networknt.consul.client.ConsulClient;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.support.AbstractRegistry;
import com.networknt.status.Status;
import com.networknt.utility.ConcurrentHashSet;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRegistry
extends AbstractRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ConsulRegistry.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    private ConsulClient client;
    private ConsulHeartbeatManager heartbeatManager;
    private long lookupInterval;
    private long reconnectInterval;
    private long reconnectJitter;
    private ConcurrentHashMap<String, List<URL>> serviceCache = new ConcurrentHashMap();
    private static Set<URL> subscribedSet = new ConcurrentHashSet<URL>();
    private ConcurrentHashMap<String, Long> lookupServices = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<URL, NotifyListener>> notifyListeners = new ConcurrentHashMap();
    private ThreadPoolExecutor notifyExecutor;
    static String MASK_KEY_CONSUL_TOKEN = "consulToken";

    public ConsulRegistry(URL url, ConsulClient client) {
        super(url);
        this.client = client;
        if (this.getConsulConfig().ttlCheck) {
            this.heartbeatManager = new ConsulHeartbeatManager(client, this.getConsulToken());
            this.heartbeatManager.start();
        }
        this.lookupInterval = this.getConsulConfig().getLookupInterval() * 1000L;
        this.reconnectInterval = this.getConsulConfig().getReconnectInterval() * 1000L;
        this.reconnectJitter = this.getConsulConfig().getReconnectJitter() * 1000L;
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(20000);
        this.notifyExecutor = new ThreadPoolExecutor(10, 30, 30000L, TimeUnit.MILLISECONDS, workQueue);
        logger.info("ConsulRegistry init finish.");
        ModuleRegistry.registerModule(ConsulRegistry.class.getName(), Config.getInstance().getJsonMapConfigNoCache("consul"), List.of(MASK_KEY_CONSUL_TOKEN));
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<URL, NotifyListener>> getNotifyListeners() {
        return this.notifyListeners;
    }

    @Override
    protected void doRegister(URL url) {
        ConsulService service = ConsulUtils.buildService(url);
        this.client.registerService(service, this.getConsulToken());
        if (this.getConsulConfig().ttlCheck) {
            this.heartbeatManager.addHeartbeatServcieId(service.getId());
        }
    }

    @Override
    protected void doUnregister(URL url) {
        ConsulService service = ConsulUtils.buildService(url);
        this.client.unregisterService(service.getId(), this.getConsulToken());
        if (this.getConsulConfig().ttlCheck) {
            this.heartbeatManager.removeHeartbeatServiceId(service.getId());
        }
    }

    @Override
    protected void doAvailable(URL url) {
        if (url == null) {
            if (this.getConsulConfig().ttlCheck) {
                this.heartbeatManager.setHeartbeatOpen(true);
            }
        } else {
            throw new UnsupportedOperationException("Command consul registry not support available by urls yet");
        }
    }

    @Override
    protected void doUnavailable(URL url) {
        if (url == null) {
            if (this.getConsulConfig().ttlCheck) {
                this.heartbeatManager.setHeartbeatOpen(false);
            }
        } else {
            throw new UnsupportedOperationException("Command consul registry not support unavailable by urls yet");
        }
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        if (!subscribedSet.contains(url)) {
            this.addNotifyListener(url, listener);
            this.startListenerThreadIfNewService(url);
            subscribedSet.add(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        ConcurrentHashMap<URL, NotifyListener> listeners = this.notifyListeners.get(ConsulUtils.getUrlClusterInfo(url));
        if (listeners != null) {
            ConcurrentHashMap<URL, NotifyListener> concurrentHashMap = listeners;
            synchronized (concurrentHashMap) {
                listeners.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<URL> doDiscover(URL url) {
        List<URL> urls2;
        String serviceName = url.getPath();
        String tag = url.getParameter("environment");
        String protocol = url.getProtocol();
        if (logger.isTraceEnabled()) {
            logger.trace("protocol = " + protocol + " serviceName = " + serviceName + " tag = " + tag);
        }
        if ((urls2 = this.serviceCache.get(serviceName)) == null || urls2.isEmpty()) {
            String string = serviceName.intern();
            synchronized (string) {
                urls2 = this.serviceCache.get(serviceName);
                if (urls2 == null || urls2.isEmpty()) {
                    ConcurrentHashMap<String, List<URL>> serviceUrls = this.lookupServiceUpdate(protocol, serviceName, false);
                    this.updateServiceCache(serviceName, serviceUrls, false);
                    urls2 = this.serviceCache.get(serviceName);
                }
            }
        }
        return urls2;
    }

    private void startListenerThreadIfNewService(URL url) {
        Long value;
        String serviceName = url.getPath();
        if (StringUtils.isBlank(serviceName)) {
            return;
        }
        String protocol = url.getProtocol();
        if (!this.lookupServices.containsKey(serviceName) && (value = this.lookupServices.putIfAbsent(serviceName, 0L)) == null) {
            ServiceLookupThread lookupThread = new ServiceLookupThread(protocol, serviceName);
            lookupThread.setDaemon(true);
            lookupThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotifyListener(URL url, NotifyListener listener) {
        String service = ConsulUtils.getUrlClusterInfo(url);
        ConcurrentHashMap<URL, NotifyListener> map = this.notifyListeners.get(service);
        if (map == null) {
            this.notifyListeners.putIfAbsent(service, new ConcurrentHashMap());
            map = this.notifyListeners.get(service);
        }
        ConcurrentHashMap<URL, NotifyListener> concurrentHashMap = map;
        synchronized (concurrentHashMap) {
            map.put(url, listener);
        }
    }

    private ConcurrentHashMap<String, List<URL>> lookupServiceUpdate(String protocol, String serviceName) {
        return this.lookupServiceUpdate(protocol, serviceName, true);
    }

    private ConcurrentHashMap<String, List<URL>> lookupServiceUpdate(String protocol, String serviceName, boolean isBlockQuery) {
        Long lastConsulIndexId = 0L;
        if (isBlockQuery) {
            lastConsulIndexId = this.lookupServices.get(serviceName) == null ? 0L : this.lookupServices.get(serviceName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("serviceName = {} lastConsulIndexId = {}", (Object)serviceName, (Object)lastConsulIndexId);
        }
        ConsulResponse<List<ConsulService>> response = this.lookupConsulService(serviceName, lastConsulIndexId);
        if (logger.isTraceEnabled()) {
            try {
                logger.trace("response = " + Config.getInstance().getMapper().writeValueAsString(response));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ConcurrentHashMap<String, List<URL>> serviceUrls = new ConcurrentHashMap<String, List<URL>>();
        if (response != null) {
            List<ConsulService> services = response.getValue();
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("services = " + Config.getInstance().getMapper().writeValueAsString(services));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (response.getConsulIndex() > lastConsulIndexId) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Got updated urls from Consul: {} instances of service {} found", (Object)services.size(), (Object)serviceName);
                }
                if (services.size() == 0) {
                    serviceUrls.put(serviceName, new ArrayList());
                }
                for (ConsulService service : services) {
                    try {
                        URL url = ConsulUtils.buildUrl(protocol, service);
                        List<URL> urlList = serviceUrls.get(serviceName);
                        if (urlList == null) {
                            urlList = new ArrayList<URL>();
                            serviceUrls.put(serviceName, urlList);
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("Consul lookupServiceUpdate url = " + url);
                        }
                        urlList.add(url);
                    }
                    catch (Exception e) {
                        logger.error("Failed to convert Consul service to url! service: " + service, e);
                    }
                }
                this.lookupServices.put(serviceName, response.getConsulIndex());
                if (logger.isDebugEnabled()) {
                    logger.debug("Consul index put into lookupServices for service: {}, index={}", (Object)serviceName, (Object)response.getConsulIndex());
                }
                return serviceUrls;
            }
            if (response.getConsulIndex() < lastConsulIndexId) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Consul returned stale index: Index reset to 0 for service {} - Consul response index < last Consul index: {} < {}", serviceName, response.getConsulIndex(), lastConsulIndexId);
                }
                this.lookupServices.put(serviceName, 0L);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Consul returned no service updates: No need to update local Consul discovery cache for service {}, lastIndex={}", (Object)serviceName, (Object)lastConsulIndexId);
            }
        } else {
            logger.error("Local service cache may be out of date for {} - Consul connection failed", (Object)serviceName);
            return null;
        }
        return serviceUrls;
    }

    private ConsulResponse<List<ConsulService>> lookupConsulService(String serviceName, Long lastConsulIndexId) {
        ConsulResponse<List<ConsulService>> response = this.client.lookupHealthService(serviceName, null, lastConsulIndexId, this.getConsulToken());
        return response;
    }

    private void updateServiceCache(String serviceName, ConcurrentHashMap<String, List<URL>> serviceUrls, boolean needNotify) {
        if (serviceUrls != null && !serviceUrls.isEmpty()) {
            List<URL> cachedUrls = this.serviceCache.get(serviceName);
            List<URL> newUrls = serviceUrls.get(serviceName);
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("serviceUrls = {}", (Object)Config.getInstance().getMapper().writeValueAsString(serviceUrls));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean change = true;
            if (ConsulUtils.isSame(newUrls, cachedUrls)) {
                change = false;
            } else {
                this.serviceCache.put(serviceName, newUrls);
            }
            if (change && needNotify) {
                this.notifyExecutor.execute(new NotifyService(serviceName, newUrls));
                if (logger.isDebugEnabled()) {
                    logger.debug("light service notify-service: " + serviceName);
                }
                StringBuilder sb = new StringBuilder();
                for (URL url : newUrls) {
                    sb.append(url.getUri()).append(";");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("consul notify urls:" + sb.toString());
                }
            }
        }
    }

    private ConsulConfig getConsulConfig() {
        return (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    }

    private String getConsulToken() {
        ConsulConfig consulConfig = this.getConsulConfig();
        String token = consulConfig.getConsulToken();
        if (token == null) {
            logger.error(new Status(CONFIG_PROPERTY_MISSING, "consulToken", "consul.yml").toString());
        }
        return token;
    }

    private class NotifyService
    implements Runnable {
        private String service;
        private List<URL> urls;

        public NotifyService(String service, List<URL> urls2) {
            this.service = service;
            this.urls = urls2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentHashMap<URL, NotifyListener> listeners = ConsulRegistry.this.notifyListeners.get(this.service);
            if (listeners != null) {
                ConcurrentHashMap<URL, NotifyListener> concurrentHashMap = listeners;
                synchronized (concurrentHashMap) {
                    for (Map.Entry<URL, NotifyListener> entry : listeners.entrySet()) {
                        NotifyListener listener = entry.getValue();
                        listener.notify(ConsulRegistry.this.getUrl(), this.urls);
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("need not notify service:" + this.service);
            }
        }
    }

    private class ServiceLookupThread
    extends Thread {
        private String protocol;
        private String serviceName;

        public ServiceLookupThread(String protocol, String serviceName) {
            this.protocol = protocol;
            this.serviceName = serviceName;
        }

        @Override
        public void run() {
            ConsulRecoveryManager consulRecovery = new ConsulRecoveryManager(this.serviceName);
            if (logger.isDebugEnabled()) {
                logger.debug("Start Consul ServiceLookupThread thread - Lookup interval: {}ms, service {}", (Object)ConsulRegistry.this.lookupInterval, (Object)this.serviceName);
            }
            while (true) {
                consulRecovery.checkin();
                try {
                    ConcurrentHashMap<String, List<URL>> serviceUrls;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Consul ServiceLookupThread Thread - SLEEP: Start to sleep {}ms for service {}", (Object)ConsulRegistry.this.lookupInterval, (Object)this.serviceName);
                    }
                    ServiceLookupThread.sleep(ConsulRegistry.this.lookupInterval);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Consul ServiceLookupThread Thread - WAKE UP: Woke up from sleep for service {}", (Object)this.serviceName);
                    }
                    if ((serviceUrls = ConsulRegistry.this.lookupServiceUpdate(this.protocol, this.serviceName)) == null) {
                        while (serviceUrls == null) {
                            consulRecovery.checkin();
                            boolean moreAttemptsPermitted = consulRecovery.newFailedAttempt();
                            if (!moreAttemptsPermitted) {
                                ConsulRecoveryManager.gracefulShutdown();
                            }
                            long randomJitter = ThreadLocalRandom.current().nextLong(0L, ConsulRegistry.this.reconnectJitter);
                            Thread.sleep(ConsulRegistry.this.reconnectInterval + randomJitter);
                            serviceUrls = ConsulRegistry.this.lookupServiceUpdate(this.protocol, this.serviceName);
                        }
                        consulRecovery.exitRecoveryMode();
                    }
                    if (serviceUrls.size() == 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("No service URL updates from Consul lookupServiceUpdate for service {}", (Object)this.serviceName);
                        } else if (logger.isDebugEnabled()) {
                            logger.debug("Got service URLs from Consul lookupServiceUpdate: {} service URLs found for service {} ({})", serviceUrls.getOrDefault(this.serviceName, Collections.emptyList()).size(), this.serviceName, this.protocol);
                        }
                    }
                    ConsulRegistry.this.updateServiceCache(this.serviceName, serviceUrls, true);
                    continue;
                }
                catch (Throwable e) {
                    logger.error("ServiceLookupThread fail!", e);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

