/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.cache.ICacheStrategy;
import com.networknt.client.oauth.cache.LongestExpireCacheStrategy;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.status.Status;
import io.undertow.client.ClientRequest;
import io.undertow.util.HeaderValues;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager {
    private Logger logger = LoggerFactory.getLogger(TokenManager.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    private static volatile TokenManager INSTANCE;
    private static int CAPACITY;
    private ICacheStrategy cacheStrategy;

    private TokenManager() {
        Map cacheConfig;
        Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
        if (tokenConfig != null && (cacheConfig = (Map)tokenConfig.get("cache")) != null && cacheConfig.get("capacity") != null) {
            CAPACITY = (Integer)cacheConfig.get("capacity");
        }
        this.cacheStrategy = new LongestExpireCacheStrategy(CAPACITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TokenManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TokenManager> clazz = TokenManager.class;
        synchronized (TokenManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TokenManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Result<Jwt> getJwt(Jwt.Key key, Map<String, Object> ccConfig) {
        Result<Jwt> result;
        Jwt cachedJwt = this.getJwt(this.cacheStrategy, key);
        if (ccConfig != null) {
            cachedJwt.setCcConfig(ccConfig);
        }
        if ((result = OauthHelper.populateCCToken(cachedJwt)).isSuccess()) {
            this.cacheStrategy.cacheJwt(key, result.getResult());
        }
        return result;
    }

    private synchronized Jwt getJwt(ICacheStrategy cacheStrategy, Jwt.Key key) {
        Jwt result = cacheStrategy.getCachedJwt(key);
        if (result == null) {
            result = new Jwt(key);
            cacheStrategy.cacheJwt(key, result);
        }
        return result;
    }

    public Result<Jwt> getJwt(ClientRequest clientRequest) {
        if (ClientConfig.get().isMultipleAuthServers()) {
            Map clientCredentials;
            Map serviceIdAuthServers;
            String path = clientRequest.getPath();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("clientRequest path = " + path);
            }
            Map<String, String> pathPrefixServices = ClientConfig.get().getPathPrefixServices();
            String serviceId = null;
            for (Map.Entry<String, String> entry : pathPrefixServices.entrySet()) {
                if (!path.startsWith(entry.getKey())) continue;
                serviceId = entry.getValue();
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("serviceId = " + serviceId);
            }
            if ((serviceIdAuthServers = (Map)(clientCredentials = (Map)ClientConfig.get().getTokenConfig().get("client_credentials")).get("serviceIdAuthServers")) == null) {
                Status status = new Status(CONFIG_PROPERTY_MISSING, "serviceIdAuthServers", "client.yml");
                return Failure.of(status);
            }
            Map ccConfig = (Map)serviceIdAuthServers.get(serviceId);
            return this.getJwt(new Jwt.Key(serviceId), ccConfig);
        }
        HeaderValues scope = clientRequest.getRequestHeaders().get("scope");
        if (scope != null) {
            String scopeStr = scope.getFirst();
            HashSet<String> scopeSet = new HashSet<String>();
            scopeSet.addAll(Arrays.asList(scopeStr.split(" ")));
            return this.getJwt(new Jwt.Key(scopeSet), null);
        }
        HeaderValues serviceId = clientRequest.getRequestHeaders().get("serviceId");
        if (serviceId != null) {
            return this.getJwt(new Jwt.Key(serviceId.getFirst()), null);
        }
        return this.getJwt(new Jwt.Key(), null);
    }

    static {
        CAPACITY = 200;
    }
}

