/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.status.Status;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthenticatedUserRequest
extends TokenRequest {
    private static final Logger logger = LoggerFactory.getLogger(ClientAuthenticatedUserRequest.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";
    private String userType;
    private String userId;
    private String roles;
    private String redirectUri;

    public ClientAuthenticatedUserRequest(String userType, String userId, String roles) {
        this.setGrantType("client_authenticated_user");
        this.setUserType(userType);
        this.setUserId(userId);
        this.setRoles(roles);
        Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
        if (tokenConfig != null) {
            this.setServerUrl((String)tokenConfig.get("server_url"));
            this.setProxyHost((String)tokenConfig.get("proxyHost"));
            int port = tokenConfig.get("proxyPort") == null ? 443 : (Integer)tokenConfig.get("proxyPort");
            this.setProxyPort(port);
            this.setServiceId((String)tokenConfig.get("serviceId"));
            Object object = tokenConfig.get("enableHttp2");
            this.setEnableHttp2(object != null && (Boolean)object != false);
            Map acConfig = (Map)tokenConfig.get("authorization_code");
            if (acConfig != null) {
                this.setClientId((String)acConfig.get("client_id"));
                if (acConfig.get("client_secret") != null) {
                    this.setClientSecret((String)acConfig.get("client_secret"));
                } else {
                    logger.error(new Status(CONFIG_PROPERTY_MISSING, "authorization_code client_secret", "client.yml").toString());
                }
                this.setUri((String)acConfig.get("uri"));
                this.setScope((List)acConfig.get("scope"));
                this.setRedirectUri((String)acConfig.get("redirect_uri"));
            }
        }
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }
}

