/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.body.BodyConfig;
import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.RequestInterceptor;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBodyInterceptor
implements RequestInterceptor {
    static final Logger logger = LoggerFactory.getLogger(RequestBodyInterceptor.class);
    static final String CONTENT_TYPE_MISMATCH = "ERR10015";
    public BodyConfig config;
    private volatile HttpHandler next;

    public RequestBodyInterceptor() {
        if (logger.isInfoEnabled()) {
            logger.info("RequestBodyInterceptor is loaded.");
        }
        this.config = BodyConfig.load();
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("RequestBodyInterceptor.handleRequest starts.");
        }
        if (this.shouldAttachBody(exchange)) {
            boolean attached = false;
            PooledByteBuffer[] existing = exchange.getAttachment(AttachmentConstants.BUFFERED_REQUEST_DATA_KEY);
            if (existing != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Attach request body requirement is met and butter exists.");
                }
                StringBuilder completeBody = new StringBuilder();
                for (PooledByteBuffer buffer : existing) {
                    if (buffer == null) break;
                    completeBody.append(StandardCharsets.UTF_8.decode(buffer.getBuffer().duplicate()).toString());
                }
                String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
                if (logger.isTraceEnabled()) {
                    logger.trace("contentType = " + contentType + " request body = " + (Serializable)((Object)(completeBody.length() > 16384 ? completeBody.substring(0, 16384) : completeBody)));
                }
                if (contentType.startsWith("application/json")) {
                    attached = this.attachJsonBody(exchange, completeBody.toString());
                } else if (contentType.startsWith("text") || contentType.startsWith("application/xml")) {
                    if (this.config.isCacheRequestBody()) {
                        exchange.putAttachment(AttachmentConstants.REQUEST_BODY_STRING, completeBody.toString());
                        attached = true;
                    }
                } else if (contentType.startsWith("multipart/form-data") || contentType.startsWith("application/x-www-form-urlencoded")) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("contentType = " + contentType + " stringBody = " + completeBody);
                    }
                    attached = this.attachFormDataBody(exchange, completeBody.toString());
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace("Request body interceptor is skipped due to the request path is not in request-injection.appliedBodyInjectionPathPrefixes configuration");
            }
            if (!attached && logger.isErrorEnabled()) {
                logger.error("Failed to attached the request body to the exchange");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RequestBodyInterceptor.handleRequest ends.");
        }
    }

    private boolean shouldAttachBody(HttpServerExchange exchange) {
        boolean hasBody;
        HttpString method = exchange.getRequestMethod();
        boolean bl = hasBody = method.equals(Methods.POST) || method.equals(Methods.PUT) || method.equals(Methods.PATCH);
        if (logger.isTraceEnabled()) {
            logger.trace("hasBody = " + hasBody);
        }
        return hasBody && exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE) != null;
    }

    private boolean attachJsonBody(HttpServerExchange exchange, String string) {
        Object body;
        if ((string = string.trim()).startsWith("{")) {
            try {
                body = Config.getInstance().getMapper().readValue(string, new TypeReference<Map<String, Object>>(){});
            }
            catch (JsonProcessingException e) {
                this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, "application/json");
                if (logger.isTraceEnabled()) {
                    logger.trace("Full request body: {}", (Object)string);
                }
                return false;
            }
        } else if (string.startsWith("[")) {
            try {
                body = Config.getInstance().getMapper().readValue(string, new TypeReference<List<Object>>(){});
            }
            catch (JsonProcessingException e) {
                this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, "application/json");
                if (logger.isTraceEnabled()) {
                    logger.trace("Full request body: {}", (Object)string);
                }
                return false;
            }
        } else {
            this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, "application/json");
            if (logger.isTraceEnabled()) {
                logger.trace("Full request body: {}", (Object)string);
            }
            return false;
        }
        if (this.config.isCacheRequestBody()) {
            exchange.putAttachment(AttachmentConstants.REQUEST_BODY_STRING, string);
        }
        exchange.putAttachment(AttachmentConstants.REQUEST_BODY, body);
        return true;
    }

    private boolean attachFormDataBody(HttpServerExchange exchange, String s2) {
        exchange.putAttachment(BodyHandler.REQUEST_BODY_STRING, s2);
        return true;
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(RequestBodyInterceptor.class.getName(), this.config.getMappedConfig(), null);
    }

    @Override
    public void reload() {
        this.config.reload();
    }

    @Override
    public boolean isRequiredContent() {
        return true;
    }
}

