/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.Validator;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.keyword.TypeValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.JsonType;
import com.networknt.schema.utils.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.JsonNode;

public class UnionTypeValidator
extends BaseKeywordValidator
implements KeywordValidator {
    private final List<Validator> schemas;
    private final String error;

    public UnionTypeValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.TYPE, schemaNode, schemaLocation, parentSchema, schemaContext);
        StringBuilder errorBuilder = new StringBuilder();
        String sep = "";
        errorBuilder.append('[');
        if (!schemaNode.isArray()) {
            throw new SchemaException("Expected array for type property on Union Type Definition.");
        }
        int i = 0;
        this.schemas = new ArrayList<Validator>(schemaNode.size());
        for (JsonNode n : schemaNode) {
            JsonType t = TypeFactory.getSchemaNodeType(n);
            errorBuilder.append(sep).append((Object)t);
            sep = ", ";
            if (n.isObject()) {
                this.schemas.add(schemaContext.newSchema(schemaLocation.append(i), n, parentSchema));
            } else {
                this.schemas.add(new TypeValidator(schemaLocation.append(i), n, parentSchema, schemaContext));
            }
            ++i;
        }
        errorBuilder.append(']');
        this.error = errorBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.schemaContext.getSchemaRegistryConfig());
        boolean valid = false;
        boolean failFast = executionContext.isFailFast();
        List<Error> existingErrors = executionContext.getErrors();
        try {
            ArrayList<Error> test = new ArrayList<Error>();
            executionContext.setFailFast(false);
            executionContext.setErrors(test);
            int schemaIndex = 0;
            for (Validator schema : this.schemas) {
                executionContext.evaluationPathAddLast(schemaIndex);
                try {
                    schema.validate(executionContext, node, rootNode, instanceLocation);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
                ++schemaIndex;
                if (test.isEmpty()) {
                    valid = true;
                    break;
                }
                test.clear();
            }
        }
        finally {
            executionContext.setFailFast(failFast);
            executionContext.setErrors(existingErrors);
        }
        if (!valid) {
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).keyword("type")).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(nodeType.toString(), this.error)).build());
        }
    }

    @Override
    public void preloadSchema() {
        for (Validator validator : this.schemas) {
            if (validator instanceof KeywordValidator) {
                ((KeywordValidator)validator).preloadSchema();
                continue;
            }
            if (!(validator instanceof Schema)) continue;
            ((Schema)validator).initializeValidators();
        }
    }

    @Override
    public String getKeyword() {
        return "type";
    }
}

