/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRef;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.SchemaRefs;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;

public class PrefixItemsValidator
extends BaseKeywordValidator {
    private final List<Schema> tupleSchema;

    public PrefixItemsValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.PREFIX_ITEMS, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (schemaNode instanceof ArrayNode && !schemaNode.isEmpty()) {
            int i = 0;
            this.tupleSchema = new ArrayList<Schema>(schemaNode.size());
            for (JsonNode s : schemaNode) {
                this.tupleSchema.add(schemaContext.newSchema(schemaLocation.append(i), s, parentSchema));
                ++i;
            }
        } else {
            throw new IllegalArgumentException("The value of 'prefixItems' MUST be a non-empty array of valid JSON Schemas.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (node.isArray()) {
            int count = Math.min(node.size(), this.tupleSchema.size());
            for (int i = 0; i < count; ++i) {
                NodePath path = instanceLocation.append(i);
                executionContext.evaluationPathAddLast(i);
                try {
                    this.tupleSchema.get(i).validate(executionContext, node.get(i), rootNode, path);
                    continue;
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
            }
            if (this.hasUnevaluatedItemsInEvaluationPath(executionContext) || this.collectAnnotations(executionContext)) {
                int schemas;
                int items = node.isArray() ? node.size() : 1;
                if (items > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
        }
    }

    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (node instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)node;
            int count = this.tupleSchema.size();
            for (int i = 0; i < count; ++i) {
                JsonNode n = node.get(i);
                if (executionContext.getWalkConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                    JsonNode defaultNode = PrefixItemsValidator.getDefaultNode(this.tupleSchema.get(i), executionContext);
                    if (n != null && n.isNull() && defaultNode != null) {
                        array.set(i, defaultNode);
                        n = defaultNode;
                    }
                }
                this.doWalk(executionContext, i, n, rootNode, instanceLocation, shouldValidateSchema);
            }
            if (this.hasUnevaluatedItemsInEvaluationPath(executionContext) || this.collectAnnotations(executionContext)) {
                int schemas;
                int items = node.isArray() ? node.size() : 1;
                if (items > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
        } else {
            int count = this.tupleSchema.size();
            for (int i = 0; i < count; ++i) {
                this.doWalk(executionContext, i, null, rootNode, instanceLocation, shouldValidateSchema);
            }
        }
    }

    private static JsonNode getDefaultNode(Schema schema, ExecutionContext executionContext) {
        SchemaRef schemaRef;
        JsonNode result = schema.getSchemaNode().get("default");
        if (result == null && (schemaRef = SchemaRefs.from(schema, executionContext)) != null) {
            result = PrefixItemsValidator.getDefaultNode(schemaRef.getSchema(), executionContext);
        }
        return result;
    }

    private void doWalk(ExecutionContext executionContext, int i, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        this.walkSchema(executionContext, i, this.tupleSchema.get(i), node, rootNode, instanceLocation.append(i), shouldValidateSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkSchema(ExecutionContext executionContext, int schemaIndex, Schema walkSchema, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        boolean executeWalk = executionContext.getWalkConfig().getItemWalkHandler().preWalk(executionContext, KeywordType.PREFIX_ITEMS.getValue(), node, rootNode, instanceLocation, walkSchema, this);
        int currentErrors = executionContext.getErrors().size();
        if (executeWalk) {
            executionContext.evaluationPathAddLast(schemaIndex);
            try {
                walkSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            }
            finally {
                executionContext.evaluationPathRemoveLast();
            }
        }
        executionContext.getWalkConfig().getItemWalkHandler().postWalk(executionContext, KeywordType.PREFIX_ITEMS.getValue(), node, rootNode, instanceLocation, walkSchema, this, executionContext.getErrors().subList(currentErrors, executionContext.getErrors().size()));
    }

    public List<Schema> getTupleSchema() {
        return this.tupleSchema;
    }

    @Override
    public void preloadSchema() {
        this.preloadSchemas(this.tupleSchema);
    }
}

