/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.SpecificationVersionRange;
import com.networknt.schema.keyword.AdditionalPropertiesValidator;
import com.networknt.schema.keyword.AllOfValidator;
import com.networknt.schema.keyword.AnyOfValidator;
import com.networknt.schema.keyword.ConstValidator;
import com.networknt.schema.keyword.ContainsValidator;
import com.networknt.schema.keyword.ContentEncodingValidator;
import com.networknt.schema.keyword.ContentMediaTypeValidator;
import com.networknt.schema.keyword.DependenciesValidator;
import com.networknt.schema.keyword.DependentRequired;
import com.networknt.schema.keyword.DependentSchemas;
import com.networknt.schema.keyword.DiscriminatorValidator;
import com.networknt.schema.keyword.DynamicRefValidator;
import com.networknt.schema.keyword.EnumValidator;
import com.networknt.schema.keyword.ExclusiveMaximumValidator;
import com.networknt.schema.keyword.ExclusiveMinimumValidator;
import com.networknt.schema.keyword.FalseValidator;
import com.networknt.schema.keyword.IfValidator;
import com.networknt.schema.keyword.ItemsLegacyValidator;
import com.networknt.schema.keyword.ItemsValidator;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.keyword.MaxItemsValidator;
import com.networknt.schema.keyword.MaxLengthValidator;
import com.networknt.schema.keyword.MaxPropertiesValidator;
import com.networknt.schema.keyword.MaximumValidator;
import com.networknt.schema.keyword.MinItemsValidator;
import com.networknt.schema.keyword.MinLengthValidator;
import com.networknt.schema.keyword.MinMaxContainsValidator;
import com.networknt.schema.keyword.MinPropertiesValidator;
import com.networknt.schema.keyword.MinimumValidator;
import com.networknt.schema.keyword.MultipleOfValidator;
import com.networknt.schema.keyword.NotAllowedValidator;
import com.networknt.schema.keyword.NotValidator;
import com.networknt.schema.keyword.OneOfValidator;
import com.networknt.schema.keyword.PatternPropertiesValidator;
import com.networknt.schema.keyword.PatternValidator;
import com.networknt.schema.keyword.PrefixItemsValidator;
import com.networknt.schema.keyword.PropertiesValidator;
import com.networknt.schema.keyword.PropertyDependenciesValidator;
import com.networknt.schema.keyword.PropertyNamesValidator;
import com.networknt.schema.keyword.ReadOnlyValidator;
import com.networknt.schema.keyword.RecursiveRefValidator;
import com.networknt.schema.keyword.RefValidator;
import com.networknt.schema.keyword.RequiredValidator;
import com.networknt.schema.keyword.TrueValidator;
import com.networknt.schema.keyword.TypeValidator;
import com.networknt.schema.keyword.UnevaluatedItemsValidator;
import com.networknt.schema.keyword.UnevaluatedPropertiesValidator;
import com.networknt.schema.keyword.UnionTypeValidator;
import com.networknt.schema.keyword.UniqueItemsValidator;
import com.networknt.schema.keyword.ValidatorFactory;
import com.networknt.schema.keyword.WriteOnlyValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.databind.JsonNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KeywordType implements Keyword
{
    ADDITIONAL_PROPERTIES("additionalProperties", AdditionalPropertiesValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    ALL_OF("allOf", AllOfValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    ANY_OF("anyOf", AnyOfValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    CONST("const", ConstValidator::new, SpecificationVersionRange.DRAFT_6_TO_DRAFT_7),
    CONTAINS("contains", ContainsValidator::new, SpecificationVersionRange.DRAFT_6_TO_DRAFT_7),
    CONTENT_ENCODING("contentEncoding", ContentEncodingValidator::new, SpecificationVersionRange.DRAFT_7),
    CONTENT_MEDIA_TYPE("contentMediaType", ContentMediaTypeValidator::new, SpecificationVersionRange.DRAFT_7),
    DEPENDENCIES("dependencies", DependenciesValidator::new, SpecificationVersionRange.ALL_VERSIONS),
    DEPENDENT_REQUIRED("dependentRequired", DependentRequired::new, SpecificationVersionRange.NONE),
    DEPENDENT_SCHEMAS("dependentSchemas", DependentSchemas::new, SpecificationVersionRange.NONE),
    DISCRIMINATOR("discriminator", DiscriminatorValidator::new, SpecificationVersionRange.NONE),
    DYNAMIC_REF("$dynamicRef", DynamicRefValidator::new, SpecificationVersionRange.NONE),
    ENUM("enum", EnumValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    EXCLUSIVE_MAXIMUM("exclusiveMaximum", ExclusiveMaximumValidator::new, SpecificationVersionRange.DRAFT_6_TO_DRAFT_7),
    EXCLUSIVE_MINIMUM("exclusiveMinimum", ExclusiveMinimumValidator::new, SpecificationVersionRange.DRAFT_6_TO_DRAFT_7),
    FALSE("false", FalseValidator::new, SpecificationVersionRange.MIN_DRAFT_6),
    FORMAT("format", null, SpecificationVersionRange.MAX_DRAFT_7){

        @Override
        public KeywordValidator newValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
            throw new UnsupportedOperationException("Use FormatKeyword instead");
        }
    }
    ,
    ID("id", null, SpecificationVersionRange.ALL_VERSIONS),
    IF_THEN_ELSE("if", IfValidator::new, SpecificationVersionRange.DRAFT_7),
    ITEMS("items", ItemsValidator::new, SpecificationVersionRange.NONE),
    ITEMS_LEGACY("items", ItemsLegacyValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MAX_CONTAINS("maxContains", MinMaxContainsValidator::new, SpecificationVersionRange.NONE),
    MAX_ITEMS("maxItems", MaxItemsValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MAX_LENGTH("maxLength", MaxLengthValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MAX_PROPERTIES("maxProperties", MaxPropertiesValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MAXIMUM("maximum", MaximumValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MIN_CONTAINS("minContains", MinMaxContainsValidator::new, SpecificationVersionRange.NONE),
    MIN_ITEMS("minItems", MinItemsValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MIN_LENGTH("minLength", MinLengthValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MIN_PROPERTIES("minProperties", MinPropertiesValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MINIMUM("minimum", MinimumValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    MULTIPLE_OF("multipleOf", MultipleOfValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    NOT_ALLOWED("notAllowed", NotAllowedValidator::new, SpecificationVersionRange.ALL_VERSIONS),
    NOT("not", NotValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    ONE_OF("oneOf", OneOfValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    PATTERN_PROPERTIES("patternProperties", PatternPropertiesValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    PATTERN("pattern", PatternValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    PREFIX_ITEMS("prefixItems", PrefixItemsValidator::new, SpecificationVersionRange.NONE),
    PROPERTIES("properties", PropertiesValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    PROPERTY_DEPENDENCIES("propertyDependencies", PropertyDependenciesValidator::new, SpecificationVersionRange.NONE),
    PROPERTY_NAMES("propertyNames", PropertyNamesValidator::new, SpecificationVersionRange.DRAFT_6_TO_DRAFT_7),
    READ_ONLY("readOnly", ReadOnlyValidator::new, SpecificationVersionRange.DRAFT_7),
    RECURSIVE_REF("$recursiveRef", RecursiveRefValidator::new, SpecificationVersionRange.NONE),
    REF("$ref", RefValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    REQUIRED("required", RequiredValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    TRUE("true", TrueValidator::new, SpecificationVersionRange.MIN_DRAFT_6),
    TYPE("type", TypeValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    UNEVALUATED_ITEMS("unevaluatedItems", UnevaluatedItemsValidator::new, SpecificationVersionRange.NONE),
    UNEVALUATED_PROPERTIES("unevaluatedProperties", UnevaluatedPropertiesValidator::new, SpecificationVersionRange.NONE),
    UNION_TYPE("unionType", UnionTypeValidator::new, SpecificationVersionRange.NONE),
    UNIQUE_ITEMS("uniqueItems", UniqueItemsValidator::new, SpecificationVersionRange.MAX_DRAFT_7),
    WRITE_ONLY("writeOnly", WriteOnlyValidator::new, SpecificationVersionRange.DRAFT_7);

    private static final Map<String, KeywordType> CONSTANTS;
    private final String value;
    private final ValidatorFactory validatorFactory;
    private final SpecificationVersionRange specificationVersionRange;

    private KeywordType(String value, ValidatorFactory validatorFactory, SpecificationVersionRange specificationVersionRange) {
        this.value = value;
        this.validatorFactory = validatorFactory;
        this.specificationVersionRange = specificationVersionRange;
    }

    public static List<KeywordType> getKeywords(SpecificationVersion specificationVersion) {
        ArrayList<KeywordType> result = new ArrayList<KeywordType>();
        for (KeywordType keyword : KeywordType.values()) {
            if (!keyword.getSpecificationVersionRange().getVersions().contains((Object)specificationVersion)) continue;
            result.add(keyword);
        }
        return result;
    }

    public static KeywordType fromValue(String value) {
        KeywordType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    @Override
    public KeywordValidator newValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        if (this.validatorFactory == null) {
            throw new UnsupportedOperationException("No suitable validator for " + this.getValue());
        }
        return this.validatorFactory.newInstance(schemaLocation, schemaNode, parentSchema, schemaContext);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public SpecificationVersionRange getSpecificationVersionRange() {
        return this.specificationVersionRange;
    }

    static {
        CONSTANTS = new HashMap<String, KeywordType>();
        for (KeywordType c : KeywordType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

