/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.JsonType;
import com.networknt.schema.utils.TypeFactory;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.DecimalNode;
import tools.jackson.databind.node.NullNode;

public class EnumValidator
extends BaseKeywordValidator
implements KeywordValidator {
    private final Set<JsonNode> nodes;
    private final String error;

    static String asString(JsonNode node) {
        if (node.isObject() || node.isArray() || node.isString()) {
            return node.toString();
        }
        return node.asString();
    }

    public EnumValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.ENUM, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (schemaNode != null && schemaNode.isArray()) {
            JsonNode nullable;
            this.nodes = new HashSet<JsonNode>();
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            String separator = "";
            for (JsonNode n : schemaNode) {
                if (n.isNumber()) {
                    this.nodes.add(this.processNumberNode(n));
                } else if (n.isArray()) {
                    ArrayNode a = this.processArrayNode((ArrayNode)n);
                    this.nodes.add((JsonNode)a);
                } else {
                    this.nodes.add(n);
                }
                sb.append(separator);
                sb.append(EnumValidator.asString(n));
                separator = ", ";
            }
            if (schemaContext.isNullableKeywordEnabled() && (nullable = parentSchema.getSchemaNode().get("nullable")) != null && nullable.asBoolean()) {
                this.nodes.add((JsonNode)NullNode.getInstance());
                separator = ", ";
                sb.append(separator);
                sb.append("null");
            }
            sb.append(']');
            this.error = sb.toString();
        } else {
            this.nodes = Collections.emptySet();
            this.error = "[none]";
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (node.isNumber()) {
            node = this.processNumberNode(node);
        } else if (node.isArray()) {
            node = this.processArrayNode((ArrayNode)node);
        }
        if (!(this.nodes.contains(node) || this.schemaContext.getSchemaRegistryConfig().isTypeLoose() && this.isTypeLooseContainsInEnum(node))) {
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.error)).build());
        }
    }

    private boolean isTypeLooseContainsInEnum(JsonNode node) {
        if (TypeFactory.getValueNodeType(node, this.schemaContext.getSchemaRegistryConfig()) == JsonType.STRING) {
            String nodeText = node.asString();
            for (JsonNode n : this.nodes) {
                String value = n.asString();
                if (value == null || !value.equals(nodeText)) continue;
                return true;
            }
        }
        return false;
    }

    protected JsonNode processNumberNode(JsonNode n) {
        return DecimalNode.valueOf((BigDecimal)n.decimalValue().stripTrailingZeros());
    }

    protected ArrayNode processArrayNode(ArrayNode node) {
        if (!this.hasNumber(node)) {
            return node;
        }
        ArrayNode a = node.deepCopy();
        for (int x = 0; x < a.size(); ++x) {
            JsonNode v = a.get(x);
            if (!v.isNumber()) continue;
            v = this.processNumberNode(v);
            a.set(x, v);
        }
        return a;
    }

    protected boolean hasNumber(ArrayNode node) {
        for (int x = 0; x < node.size(); ++x) {
            JsonNode v = node.get(x);
            if (!v.isNumber()) continue;
            return true;
        }
        return false;
    }
}

