/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.InvalidSchemaRefException;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRef;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.RefValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.ThreadSafeCachingSupplier;
import java.util.Iterator;
import java.util.function.Supplier;
import tools.jackson.databind.JsonNode;

public class DynamicRefValidator
extends BaseKeywordValidator {
    public DynamicRefValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.DYNAMIC_REF, schemaNode, schemaLocation, parentSchema, schemaContext);
    }

    static SchemaRef getRefSchema(Schema parentSchema, String refValue, ExecutionContext executionContext) {
        String ref = DynamicRefValidator.resolve(parentSchema, refValue);
        return new SchemaRef(DynamicRefValidator.getSupplier(() -> {
            SchemaContext schemaContext = parentSchema.getSchemaContext();
            Schema refSchema = (Schema)parentSchema.getSchemaContext().getDynamicAnchors().get(ref);
            if (refSchema == null) {
                SchemaRef r = RefValidator.getRefSchema(parentSchema, schemaContext, refValue);
                if (r != null) {
                    refSchema = r.getSchema();
                }
            } else {
                int index = ref.indexOf("#");
                String anchor = ref.substring(index);
                String absoluteIri = ref.substring(0, index);
                Iterator<Schema> iter = executionContext.getEvaluationSchema().descendingIterator();
                while (iter.hasNext()) {
                    Schema base = iter.next();
                    String baseAbsoluteIri = base.getSchemaLocation().getAbsoluteIri() != null ? base.getSchemaLocation().getAbsoluteIri().toString() : "";
                    if (baseAbsoluteIri.equals(absoluteIri)) continue;
                    absoluteIri = baseAbsoluteIri;
                    String parentRef = SchemaLocation.resolve(base.getSchemaLocation(), anchor);
                    Schema parentRefSchema = (Schema)base.getSchemaContext().getDynamicAnchors().get(parentRef);
                    if (parentRefSchema == null) continue;
                    refSchema = parentRefSchema;
                }
            }
            return refSchema;
        }, false));
    }

    static <T> Supplier<T> getSupplier(Supplier<T> supplier, boolean cache) {
        return cache ? new ThreadSafeCachingSupplier(supplier) : supplier;
    }

    private static String resolve(Schema parentSchema, String refValue) {
        Schema base = parentSchema;
        if (parentSchema.getId() != null && parentSchema.getParentSchema() != null) {
            base = parentSchema.getParentSchema();
        }
        return SchemaLocation.resolve(base.getSchemaLocation(), refValue);
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        Schema refSchema = this.getSchemaRef(executionContext).getSchema();
        if (refSchema == null) {
            Error error = ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().keyword(KeywordType.DYNAMIC_REF.getValue())).messageKey("internal.unresolvedRef")).message("Reference {0} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).arguments(this.schemaNode.asString())).build();
            throw new InvalidSchemaRefException(error);
        }
        refSchema.validate(executionContext, node, rootNode, instanceLocation);
    }

    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        Schema refSchema = this.getSchemaRef(executionContext).getSchema();
        if (refSchema == null) {
            Error error = ((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().keyword(KeywordType.DYNAMIC_REF.getValue())).messageKey("internal.unresolvedRef")).message("Reference {0} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).arguments(this.schemaNode.asString())).build();
            throw new InvalidSchemaRefException(error);
        }
        if (node == null) {
            boolean circularDependency = false;
            SchemaLocation schemaLocation = refSchema.getSchemaLocation();
            Iterator<Schema> iter = executionContext.getEvaluationSchema().descendingIterator();
            while (iter.hasNext()) {
                Schema check = iter.next();
                if (!check.getSchemaLocation().equals(schemaLocation)) continue;
                circularDependency = true;
                break;
            }
            if (circularDependency) {
                return;
            }
        }
        refSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
    }

    public SchemaRef getSchemaRef(ExecutionContext executionContext) {
        String refValue = this.schemaNode.asString();
        return DynamicRefValidator.getRefSchema(this.getParentSchema(), refValue, executionContext);
    }
}

