/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.annotation.Annotation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.regex.RegularExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tools.jackson.databind.JsonNode;

public class AdditionalPropertiesValidator
extends BaseKeywordValidator {
    private final boolean allowAdditionalProperties;
    private final Schema additionalPropertiesSchema;
    private final Set<String> allowedProperties;
    private final List<RegularExpression> patternProperties;

    public AdditionalPropertiesValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.ADDITIONAL_PROPERTIES, schemaNode, schemaLocation, parentSchema, schemaContext);
        JsonNode patternPropertiesNode;
        if (schemaNode.isBoolean()) {
            this.allowAdditionalProperties = schemaNode.booleanValue();
            this.additionalPropertiesSchema = null;
        } else if (schemaNode.isObject()) {
            this.allowAdditionalProperties = true;
            this.additionalPropertiesSchema = schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
        } else {
            this.allowAdditionalProperties = false;
            this.additionalPropertiesSchema = null;
        }
        JsonNode propertiesNode = parentSchema.getSchemaNode().get("properties");
        if (propertiesNode != null) {
            this.allowedProperties = new HashSet<String>();
            Iterator it = propertiesNode.propertyNames().iterator();
            while (it.hasNext()) {
                this.allowedProperties.add((String)it.next());
            }
        } else {
            this.allowedProperties = Collections.emptySet();
        }
        if ((patternPropertiesNode = parentSchema.getSchemaNode().get("patternProperties")) != null) {
            this.patternProperties = new ArrayList<RegularExpression>(patternPropertiesNode.size());
            Iterator it = patternPropertiesNode.propertyNames().iterator();
            while (it.hasNext()) {
                this.patternProperties.add(RegularExpression.compile((String)it.next(), schemaContext));
            }
        } else {
            this.patternProperties = Collections.emptyList();
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    protected void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean walk) {
        boolean collectAnnotations;
        if (!node.isObject()) {
            return;
        }
        LinkedHashSet<String> matchedInstancePropertyNames = null;
        boolean bl = collectAnnotations = this.hasUnevaluatedPropertiesInEvaluationPath(executionContext) || this.collectAnnotations(executionContext);
        if (this.allowAdditionalProperties && collectAnnotations) {
            Iterator it = node.propertyNames().iterator();
            while (it.hasNext()) {
                if (matchedInstancePropertyNames == null) {
                    matchedInstancePropertyNames = new LinkedHashSet<String>();
                }
                String fieldName = (String)it.next();
                matchedInstancePropertyNames.add(fieldName);
            }
        }
        for (Map.Entry entry : node.properties()) {
            String pname = (String)entry.getKey();
            if (pname.startsWith("#") || this.allowedProperties.contains(pname) || this.handledByPatternProperties(pname)) continue;
            if (!this.allowAdditionalProperties) {
                executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).property(pname)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(pname)).build());
                continue;
            }
            if (this.additionalPropertiesSchema == null) continue;
            if (!walk) {
                this.additionalPropertiesSchema.validate(executionContext, (JsonNode)entry.getValue(), rootNode, instanceLocation.append(pname));
                continue;
            }
            this.additionalPropertiesSchema.walk(executionContext, (JsonNode)entry.getValue(), rootNode, instanceLocation.append(pname), true);
        }
        if (collectAnnotations) {
            executionContext.getAnnotations().put(Annotation.builder().instanceLocation(instanceLocation).evaluationPath(executionContext.getEvaluationPath()).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(matchedInstancePropertyNames != null ? matchedInstancePropertyNames : Collections.emptySet()).build());
        }
    }

    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema && node != null) {
            this.validate(executionContext, node, rootNode, instanceLocation, true);
            return;
        }
        if (node == null || !node.isObject()) {
            return;
        }
        for (String pname : node.propertyNames()) {
            if (pname.startsWith("#") || this.allowedProperties.contains(pname) || this.handledByPatternProperties(pname) || !this.allowAdditionalProperties || this.additionalPropertiesSchema == null) continue;
            this.additionalPropertiesSchema.walk(executionContext, node.get(pname), rootNode, instanceLocation.append(pname), shouldValidateSchema);
        }
    }

    private boolean handledByPatternProperties(String pname) {
        for (RegularExpression pattern : this.patternProperties) {
            if (!pattern.matches(pname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void preloadSchema() {
        if (this.additionalPropertiesSchema != null) {
            this.additionalPropertiesSchema.initializeValidators();
        }
    }
}

