/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.Schema;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import tools.jackson.databind.JsonNode;

public class ErrorMessages {
    public static Map<String, String> getErrorMessage(Schema parentSchema, String errorMessageKeyword, String keyword) {
        JsonNode messageNode;
        JsonNode message = ErrorMessages.getMessageNode(errorMessageKeyword, parentSchema.schemaNode, parentSchema, keyword);
        if (message != null && (messageNode = message.get(keyword)) != null) {
            if (messageNode.isString()) {
                return Collections.singletonMap("", messageNode.asString());
            }
            if (messageNode.isObject()) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                messageNode.properties().iterator().forEachRemaining(entry -> result.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asString()));
                if (!result.isEmpty()) {
                    return result;
                }
            }
        }
        return Collections.emptyMap();
    }

    protected static JsonNode getMessageNode(String errorMessageKeyword, JsonNode schemaNode, Schema parentSchema, String pname) {
        if (schemaNode.get(errorMessageKeyword) != null && schemaNode.get(errorMessageKeyword).get(pname) != null) {
            return schemaNode.get(errorMessageKeyword);
        }
        JsonNode messageNode = schemaNode.get(errorMessageKeyword);
        if (messageNode == null && parentSchema != null && (messageNode = parentSchema.schemaNode.get(errorMessageKeyword)) == null) {
            return ErrorMessages.getMessageNode(errorMessageKeyword, parentSchema.schemaNode, parentSchema.getParentSchema(), pname);
        }
        return messageNode;
    }
}

