/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyNamesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(PropertyNamesValidator.class);
    private final JsonSchema innerSchema;

    public PropertyNamesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTYNAMES, validationContext);
        this.innerSchema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        PropertyNamesValidator.debug(logger, node, rootNode, instanceLocation);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String pname = (String)it.next();
            TextNode pnameText = TextNode.valueOf((String)pname);
            Set<ValidationMessage> schemaErrors = this.innerSchema.validate(executionContext, (JsonNode)pnameText, node, instanceLocation.append(pname));
            for (ValidationMessage schemaError : schemaErrors) {
                String path = schemaError.getInstanceLocation().toString();
                String msg = schemaError.getMessage();
                if (msg.startsWith(path)) {
                    msg = msg.substring(path.length()).replaceFirst("^:\\s*", "");
                }
                errors.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().property(pname)).instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(pname, msg)).build());
            }
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        this.innerSchema.initializeValidators();
    }
}

