/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.output;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.output.OutputUnit;
import com.networknt.schema.output.OutputUnitData;
import com.networknt.schema.output.OutputUnitKey;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class HierarchicalOutputUnitFormatter {
    public static OutputUnit format(JsonSchema jsonSchema, Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
        String schemaLocation;
        String instanceLocation;
        OutputUnit unit;
        OutputUnitKey key;
        OutputUnit root = new OutputUnit();
        root.setValid(validationMessages.isEmpty());
        root.setInstanceLocation(validationContext.getConfig().getPathType().getRoot());
        root.setEvaluationPath(validationContext.getConfig().getPathType().getRoot());
        root.setSchemaLocation(jsonSchema.getSchemaLocation().toString());
        OutputUnitData data = OutputUnitData.from(validationMessages, executionContext);
        Map<OutputUnitKey, Boolean> valid = data.getValid();
        Map<OutputUnitKey, Map<String, String>> errors = data.getErrors();
        Map<OutputUnitKey, Map<String, Object>> annotations = data.getAnnotations();
        Map<OutputUnitKey, Map<String, Object>> droppedAnnotations = data.getDroppedAnnotations();
        LinkedHashMap<JsonNodePath, OutputUnit> index = new LinkedHashMap<JsonNodePath, OutputUnit>();
        index.put(new JsonNodePath(validationContext.getConfig().getPathType()), root);
        LinkedHashSet keys = new LinkedHashSet();
        errors.keySet().stream().forEach(k -> keys.add(k.getEvaluationPath()));
        annotations.keySet().stream().forEach(k -> keys.add(k.getEvaluationPath()));
        droppedAnnotations.keySet().stream().forEach(k -> keys.add(k.getEvaluationPath()));
        errors.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        annotations.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        droppedAnnotations.keySet().stream().forEach(k -> HierarchicalOutputUnitFormatter.buildIndex(k, index, keys, root));
        for (Map.Entry<OutputUnitKey, Map<String, String>> error : errors.entrySet()) {
            key = error.getKey();
            unit = (OutputUnit)index.get(key.getEvaluationPath());
            unit.setInstanceLocation(key.getInstanceLocation().toString());
            unit.setSchemaLocation(key.getSchemaLocation().toString());
            unit.setValid(false);
            unit.setErrors(error.getValue());
        }
        for (Map.Entry<OutputUnitKey, Map<String, Object>> annotation : annotations.entrySet()) {
            key = annotation.getKey();
            unit = (OutputUnit)index.get(key.getEvaluationPath());
            instanceLocation = key.getInstanceLocation().toString();
            schemaLocation = key.getSchemaLocation().toString();
            if (unit.getInstanceLocation() != null && !unit.getInstanceLocation().equals(instanceLocation)) {
                throw new IllegalArgumentException();
            }
            if (unit.getSchemaLocation() != null && !unit.getSchemaLocation().equals(schemaLocation)) {
                throw new IllegalArgumentException();
            }
            unit.setInstanceLocation(instanceLocation);
            unit.setSchemaLocation(schemaLocation);
            unit.setAnnotations(annotation.getValue());
            unit.setValid(valid.get(key));
        }
        for (Map.Entry<OutputUnitKey, Map<String, Object>> droppedAnnotation : droppedAnnotations.entrySet()) {
            key = droppedAnnotation.getKey();
            unit = (OutputUnit)index.get(key.getEvaluationPath());
            instanceLocation = key.getInstanceLocation().toString();
            schemaLocation = key.getSchemaLocation().toString();
            if (unit.getInstanceLocation() != null && !unit.getInstanceLocation().equals(instanceLocation)) {
                throw new IllegalArgumentException();
            }
            if (unit.getSchemaLocation() != null && !unit.getSchemaLocation().equals(schemaLocation)) {
                throw new IllegalArgumentException();
            }
            unit.setInstanceLocation(instanceLocation);
            unit.setSchemaLocation(schemaLocation);
            unit.setDroppedAnnotations(droppedAnnotation.getValue());
            unit.setValid(valid.get(key));
        }
        return root;
    }

    protected static void buildIndex(OutputUnitKey key, Map<JsonNodePath, OutputUnit> index, Set<JsonNodePath> keys, OutputUnit root) {
        if (index.containsKey(key.getEvaluationPath())) {
            return;
        }
        ArrayDeque<JsonNodePath> stack = new ArrayDeque<JsonNodePath>();
        for (JsonNodePath path = key.getEvaluationPath(); path != null && path.getElement(-1) != null; path = path.getParent()) {
            stack.push(path);
        }
        OutputUnit parent = root;
        while (!stack.isEmpty()) {
            OutputUnit child;
            JsonNodePath current = (JsonNodePath)stack.pop();
            if (!index.containsKey(current) && keys.contains(current)) {
                child = new OutputUnit();
                child.setValid(true);
                child.setEvaluationPath(current.toString());
                index.put(current, child);
                if (parent.getDetails() == null) {
                    parent.setDetails(new ArrayList<OutputUnit>());
                }
                parent.getDetails().add(child);
            }
            if ((child = index.get(current)) == null) continue;
            parent = child;
        }
    }
}

