/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CachedSupplier;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaRef;
import com.networknt.schema.RefValidator;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DynamicRefValidator.class);
    protected JsonSchemaRef schema;

    public DynamicRefValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = DynamicRefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue, JsonNodePath evaluationPath) {
        String ref = DynamicRefValidator.resolve(parentSchema, refValue);
        return new JsonSchemaRef(new CachedSupplier<JsonSchema>(() -> {
            JsonSchema refSchema = (JsonSchema)validationContext.getDynamicAnchors().get(ref);
            if (refSchema == null) {
                JsonSchemaRef r = RefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
                if (r != null) {
                    refSchema = r.getSchema();
                }
            } else {
                JsonSchema base = parentSchema;
                int index = ref.indexOf("#");
                String anchor = ref.substring(index);
                String absoluteIri = ref.substring(0, index);
                while (base.getEvaluationParentSchema() != null) {
                    String baseAbsoluteIri = (base = base.getEvaluationParentSchema()).getSchemaLocation().getAbsoluteIri() != null ? base.getSchemaLocation().getAbsoluteIri().toString() : "";
                    if (baseAbsoluteIri.equals(absoluteIri)) continue;
                    absoluteIri = baseAbsoluteIri;
                    String parentRef = SchemaLocation.resolve(base.getSchemaLocation(), anchor);
                    JsonSchema parentRefSchema = (JsonSchema)validationContext.getDynamicAnchors().get(parentRef);
                    if (parentRefSchema == null) continue;
                    refSchema = parentRefSchema;
                }
            }
            if (refSchema != null) {
                refSchema = refSchema.fromRef(parentSchema, evaluationPath);
            }
            return refSchema;
        }));
    }

    private static String resolve(JsonSchema parentSchema, String refValue) {
        JsonSchema base = parentSchema;
        if (parentSchema.getId() != null && parentSchema.parentSchema != null) {
            base = parentSchema.parentSchema;
        }
        return SchemaLocation.resolve(base.getSchemaLocation(), refValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<Object> errors = Collections.emptySet();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            DynamicRefValidator.debug(logger, node, rootNode, instanceLocation);
            JsonSchema refSchema = this.schema.getSchema();
            if (refSchema == null) {
                ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type(ValidatorTypeCode.REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
                throw new JsonSchemaException(validationMessage);
            }
            errors = refSchema.validate(executionContext, node, rootNode, instanceLocation);
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        CollectorContext collectorContext = executionContext.getCollectorContext();
        Set<Object> errors = Collections.emptySet();
        CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
        try {
            DynamicRefValidator.debug(logger, node, rootNode, instanceLocation);
            JsonSchema refSchema = this.schema.getSchema();
            if (refSchema == null) {
                ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type(ValidatorTypeCode.REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
                throw new JsonSchemaException(validationMessage);
            }
            Set<Object> set = errors = refSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
            return set;
        }
        finally {
            CollectorContext.Scope scope = collectorContext.exitDynamicScope();
            if (shouldValidateSchema && errors.isEmpty()) {
                parentScope.mergeWith(scope);
            }
        }
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        JsonSchema jsonSchema = null;
        try {
            jsonSchema = this.schema.getSchema();
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JsonSchemaException(e);
        }
        SchemaLocation schemaLocation = jsonSchema.getSchemaLocation();
        JsonSchema check = jsonSchema;
        boolean circularDependency = false;
        while (check.getEvaluationParentSchema() != null) {
            if (!(check = check.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
            circularDependency = true;
            break;
        }
        if (!circularDependency) {
            jsonSchema.initializeValidators();
        }
    }
}

