/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AllOfValidator.class);
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public AllOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ALL_OF, validationContext);
        this.validationContext = validationContext;
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(validationContext.newSchema(schemaPath + "/" + i, schemaNode.get(i), parentSchema));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, String at) {
        AllOfValidator.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = executionContext.getCollectorContext();
        ValidatorState state = (ValidatorState)collectorContext.get("com.networknt.schema.ValidatorState");
        LinkedHashSet<Object> childSchemaErrors = new LinkedHashSet<Object>();
        for (JsonSchema schema : this.schemas) {
            Set<Object> localErrors = new HashSet();
            CollectorContext.Scope parentScope = collectorContext.enterDynamicScope();
            try {
                localErrors = !state.isWalkEnabled() ? schema.validate(executionContext, node, rootNode, at) : schema.walk(executionContext, node, rootNode, at, true);
                childSchemaErrors.addAll(localErrors);
                if (!this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) continue;
                Iterator arrayElements = this.schemaNode.elements();
                while (arrayElements.hasNext()) {
                    ObjectNode discriminator;
                    ValidationContext.DiscriminatorContext currentDiscriminatorContext;
                    ObjectNode allOfEntry = (ObjectNode)arrayElements.next();
                    JsonNode $ref = allOfEntry.get("$ref");
                    if (null == $ref || null == (currentDiscriminatorContext = this.validationContext.getCurrentDiscriminatorContext()) || null == (discriminator = currentDiscriminatorContext.getDiscriminatorForPath(allOfEntry.get("$ref").asText()))) continue;
                    AllOfValidator.registerAndMergeDiscriminator(currentDiscriminatorContext, discriminator, this.parentSchema, at);
                    String discriminatorPropertyName = discriminator.get("propertyName").asText();
                    JsonNode discriminatorNode = node.get(discriminatorPropertyName);
                    String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.textValue();
                    JsonSchema jsonSchema = this.parentSchema;
                    AllOfValidator.checkDiscriminatorMatch(currentDiscriminatorContext, discriminator, discriminatorPropertyValue, jsonSchema);
                }
            }
            finally {
                CollectorContext.Scope scope = collectorContext.exitDynamicScope();
                if (!localErrors.isEmpty()) continue;
                parentScope.mergeWith(scope);
            }
        }
        return Collections.unmodifiableSet(childSchemaErrors);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(executionContext, node, rootNode, at);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(executionContext, node, rootNode, at, false);
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

