/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ThresholdMixin;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimumValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MinimumValidator.class);
    private static final String PROPERTY_EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private boolean excluded = false;
    private final ThresholdMixin typedMinimum;

    public MinimumValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MINIMUM, validationContext);
        if (!schemaNode.isNumber()) {
            throw new JsonSchemaException("minimum value is not a number");
        }
        JsonNode exclusiveMinimumNode = this.getParentSchema().getSchemaNode().get(PROPERTY_EXCLUSIVE_MINIMUM);
        if (exclusiveMinimumNode != null && exclusiveMinimumNode.isBoolean()) {
            this.excluded = exclusiveMinimumNode.booleanValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        if (!JsonType.INTEGER.toString().equals(this.getNodeFieldType())) {
            final double dmin = schemaNode.doubleValue();
            this.typedMinimum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    double value = node.asDouble();
                    return MinimumValidator.this.lessThan(value, dmin) || MinimumValidator.this.excluded && MinimumValidator.this.equals(value, dmin);
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(dmin);
                }
            };
        } else if (schemaNode.isLong() || schemaNode.isInt()) {
            final long lmin = schemaNode.asLong();
            this.typedMinimum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    long val = node.asLong();
                    if (node.isBigInteger()) {
                        return node.bigIntegerValue().compareTo(new BigInteger(String.valueOf(Long.MIN_VALUE))) < 0;
                    }
                    return lmin > val || MinimumValidator.this.excluded && lmin >= val;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(lmin);
                }
            };
        } else {
            final BigInteger bimin = new BigInteger(schemaNode.asText());
            this.typedMinimum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    int cmp = bimin.compareTo(node.bigIntegerValue());
                    return cmp > 0 || MinimumValidator.this.excluded && cmp >= 0;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(bimin);
                }
            };
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (!TypeValidator.isNumber(node, this.config.isTypeLoose())) {
            return Collections.emptySet();
        }
        if (this.typedMinimum.crossesThreshold(node)) {
            return Collections.singleton(this.buildValidationMessage(at, this.typedMinimum.thresholdValue()));
        }
        return Collections.emptySet();
    }
}

