/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ContainsValidator.class);
    private int min = 1;
    private int max = Integer.MAX_VALUE;
    private final JsonSchema schema;
    private final String messageKeyMax = "contains.max";
    private final String messageKeyMin;

    public ContainsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.CONTAINS, validationContext);
        SpecVersion.VersionFlag version = SpecVersionDetector.detectOptionalVersion(parentSchema.getSchemaNode()).orElse(SpecVersion.VersionFlag.V6);
        String string = this.messageKeyMin = SpecVersion.VersionFlag.V6 == version ? "contains" : "contains.min";
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            JsonNode minNode;
            this.schema = new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode, parentSchema);
            JsonNode maxNode = parentSchema.getSchemaNode().get("maxContains");
            if (null != maxNode && maxNode.canConvertToExactIntegral()) {
                this.max = maxNode.intValue();
            }
            if (null != (minNode = parentSchema.getSchemaNode().get("minContains")) && minNode.canConvertToExactIntegral()) {
                this.min = minNode.intValue();
            }
        } else {
            this.schema = null;
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (null != this.schema && node.isArray()) {
            int actual = 0;
            int i = 0;
            for (JsonNode n : node) {
                if (this.schema.validate(n, rootNode, this.atPath(at, i)).isEmpty()) {
                    ++actual;
                }
                ++i;
            }
            if (actual < this.min) {
                return this.boundsViolated(this.messageKeyMin, at, this.min);
            }
            if (actual > this.max) {
                return this.boundsViolated("contains.max", at, this.max);
            }
        }
        return Collections.emptySet();
    }

    private Set<ValidationMessage> boundsViolated(String messageKey, String at, int bounds) {
        return Collections.singleton(this.constructValidationMessage(messageKey, at, "" + bounds, this.schema.getSchemaNode().toString()));
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
    }
}

