/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private static final String REMARK = "Remaining validation messages report why candidate schemas didn't match";
    private static final String DISCRIMINATOR_REMARK = "and the discriminator-selected candidate schema didn't pass validation";
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();
    private final ValidationContext.DiscriminatorContext discriminatorContext;

    public AnyOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        this.validationContext = validationContext;
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode.get(i), parentSchema));
        }
        this.discriminatorContext = this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() ? new ValidationContext.DiscriminatorContext() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
            this.validationContext.enterDiscriminatorContext(this.discriminatorContext, at);
        }
        LinkedHashSet<ValidationMessage> allErrors = new LinkedHashSet<ValidationMessage>();
        String typeValidatorName = "anyOf/type";
        Object backupEvaluatedProperties = CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties");
        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", new ArrayList());
        try {
            for (JsonSchema schema : this.schemas) {
                TypeValidator typeValidator;
                if (schema.getValidators().containsKey(typeValidatorName) && (typeValidator = (TypeValidator)schema.getValidators().get(typeValidatorName)).getSchemaType() != JsonType.UNION && !typeValidator.equalsToSchemaType(node)) {
                    allErrors.add(this.buildValidationMessage(at, typeValidator.getSchemaType().toString()));
                    continue;
                }
                Set<ValidationMessage> errors = schema.validate(node, rootNode, at);
                if (errors.isEmpty() && !this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                    allErrors.clear();
                    Set<ValidationMessage> set = errors;
                    return set;
                }
                if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && this.discriminatorContext.isDiscriminatorMatchFound()) {
                    if (!errors.isEmpty()) {
                        errors.add(this.buildValidationMessage(at, DISCRIMINATOR_REMARK));
                        allErrors.addAll(errors);
                    } else {
                        allErrors.clear();
                    }
                    Set<ValidationMessage> set = errors;
                    return set;
                }
                allErrors.addAll(errors);
            }
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && this.discriminatorContext.isActive()) {
                HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
                errors.add(this.buildValidationMessage(at, "based on the provided discriminator. No alternative could be chosen based on the discriminator property"));
                Set<ValidationMessage> set = Collections.unmodifiableSet(errors);
                return set;
            }
        }
        finally {
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                this.validationContext.leaveDiscriminatorContextImmediately(at);
            }
            if (allErrors.isEmpty()) {
                this.addEvaluatedProperties(backupEvaluatedProperties);
            } else {
                CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedProperties);
            }
        }
        return Collections.unmodifiableSet(allErrors);
    }

    private void addEvaluatedProperties(Object backupEvaluatedProperties) {
        List backupEvaluatedPropertiesList = backupEvaluatedProperties == null ? new ArrayList() : (List)backupEvaluatedProperties;
        backupEvaluatedPropertiesList.addAll((List)CollectorContext.getInstance().get("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties"));
        CollectorContext.getInstance().add("com.networknt.schema.UnEvaluatedPropertiesValidator.EvaluatedProperties", backupEvaluatedPropertiesList);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        ArrayList<Set<ValidationMessage>> results = new ArrayList<Set<ValidationMessage>>(this.schemas.size());
        for (JsonSchema schema : this.schemas) {
            results.add(schema.walk(node, rootNode, at, shouldValidateSchema));
        }
        if (!shouldValidateSchema) {
            return new LinkedHashSet<ValidationMessage>();
        }
        boolean atLeastOneValid = results.stream().anyMatch(Set::isEmpty);
        if (atLeastOneValid) {
            return new LinkedHashSet<ValidationMessage>();
        }
        return results.stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

