/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.url.URLFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchema schema;
    private static final String REF_CURRENT = "#";

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue);
        if (this.schema == null) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.REF.getValue(), CustomErrorMessageType.of("internal.unresolvedRef", new MessageFormat("{0}: Reference {1} cannot be resolved")), schemaPath, refValue));
        }
    }

    static JsonSchema getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue) {
        if (!refValue.startsWith(REF_CURRENT)) {
            int index = refValue.indexOf(REF_CURRENT);
            String refUrl = index > 0 ? refValue.substring(0, index) : refValue;
            URL schemaUrl = RefValidator.determineSchemaUrl(parentSchema, refUrl);
            if (schemaUrl == null) {
                return null;
            }
            parentSchema = validationContext.getJsonSchemaFactory().getSchema(schemaUrl, validationContext.getConfig());
            if (index < 0) {
                return parentSchema.findAncestor();
            }
            refValue = refValue.substring(index);
        }
        if (refValue.equals(REF_CURRENT)) {
            return parentSchema.findAncestor();
        }
        JsonNode node = parentSchema.getRefSchemaNode(refValue);
        if (node != null) {
            return new JsonSchema(validationContext, refValue, parentSchema.getCurrentUrl(), node, parentSchema);
        }
        return null;
    }

    private static URL determineSchemaUrl(JsonSchema parentSchema, String refUrl) {
        URL schemaUrl;
        try {
            schemaUrl = URLFactory.toURL(refUrl);
        }
        catch (MalformedURLException e) {
            try {
                schemaUrl = URLFactory.toURL(parentSchema.getCurrentUrl(), refUrl);
            }
            catch (MalformedURLException e2) {
                schemaUrl = null;
            }
        }
        return schemaUrl;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.schema != null) {
            return this.schema.validate(node, rootNode, at);
        }
        return Collections.emptySet();
    }
}

