/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class BaseJsonValidator
implements JsonValidator {
    private String schemaPath;
    private JsonNode schemaNode;
    private JsonSchema parentSchema;
    private JsonSchema subSchema;
    private ValidatorTypeCode validatorType;
    private String errorCode;

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType) {
        this.schemaPath = schemaPath;
        this.schemaNode = schemaNode;
        this.parentSchema = parentSchema;
        this.validatorType = validatorType;
        this.subSchema = this.obainSubSchemaNode(schemaNode);
    }

    public BaseJsonValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidatorTypeCode validatorType, JsonSchema subSchema) {
        this.schemaPath = schemaPath;
        this.schemaNode = schemaNode;
        this.parentSchema = parentSchema;
        this.validatorType = validatorType;
        this.subSchema = subSchema;
    }

    protected String getSchemaPath() {
        return this.schemaPath;
    }

    protected JsonNode getSchemaNode() {
        return this.schemaNode;
    }

    protected JsonSchema getParentSchema() {
        return this.parentSchema;
    }

    protected JsonSchema getSubSchema() {
        return this.subSchema;
    }

    protected boolean hasSubSchema() {
        return this.subSchema != null;
    }

    protected JsonSchema obainSubSchemaNode(JsonNode schemaNode) {
        JsonNode node = schemaNode.get("id");
        if (node == null) {
            return null;
        }
        if (node.equals((Object)schemaNode.get("$schema"))) {
            return null;
        }
        try {
            JsonSchemaFactory factory = new JsonSchemaFactory();
            URL url = new URL(node.textValue());
            return factory.getSchema(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, "$");
    }

    protected boolean equals(double n1, double n2) {
        return Math.abs(n1 - n2) < 1.0E-12;
    }

    protected boolean greaterThan(double n1, double n2) {
        return n1 - n2 > 1.0E-12;
    }

    protected boolean lessThan(double n1, double n2) {
        return n1 - n2 < -1.0E-12;
    }

    protected void parseErrorCode(String errorCodeKey) {
        JsonNode errorCodeNode = this.getParentSchema().getSchemaNode().get(errorCodeKey);
        if (errorCodeNode != null && errorCodeNode.isTextual()) {
            this.errorCode = errorCodeNode.asText();
        }
    }

    private String getErrorCode() {
        return this.errorCode;
    }

    private boolean isUsingCustomErrorCode() {
        return StringUtils.isNotBlank((CharSequence)this.errorCode);
    }

    protected ValidationMessage buildValidationMessage(String at, String ... arguments) {
        ValidationMessage.Builder builder = new ValidationMessage.Builder();
        if (this.isUsingCustomErrorCode()) {
            builder.code(this.getErrorCode()).path(at).arguments(arguments).type(this.validatorType.getValue());
        } else {
            builder.code(this.validatorType.getErrorCode()).path(at).arguments(arguments).format(this.validatorType.getMessageFormat()).type(this.validatorType.getValue());
        }
        return builder.build();
    }

    protected void debug(Logger logger, JsonNode node, JsonNode rootNode, String at) {
        if (logger.isDebugEnabled()) {
            logger.debug("validate( " + node + ", " + rootNode + ", " + at + ")");
        }
    }

    protected ValidatorTypeCode getValidatorType() {
        return this.validatorType;
    }
}

