/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtility {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtility.class);

    public static String jsonFromMap(Map<String, Object> jsonData) {
        try {
            JsonDocument json = new JsonDocument();
            json.startGroup();
            for (String key : jsonData.keySet()) {
                Object data = jsonData.get(key);
                if (data instanceof Map) {
                    json.addValue(key, JsonUtility.jsonFromMap((Map)data));
                    continue;
                }
                if (data instanceof Object[]) {
                    json.addValue(key, "[" + JsonUtility.stringArrayFromObjectArray((Object[])data) + "]");
                    continue;
                }
                if (data instanceof Collection) {
                    json.addValue(key, "[" + JsonUtility.stringArrayFromObjectArray(((Collection)data).toArray()) + "]");
                    continue;
                }
                if (data instanceof int[]) {
                    String intArray = Arrays.toString((int[])data);
                    intArray = intArray.replaceAll(" ", "");
                    json.addValue(key, intArray);
                    continue;
                }
                if (data instanceof JsonCapableObject) {
                    json.addValue(key, JsonUtility.jsonFromMap(((JsonCapableObject)data).jsonMap()));
                    continue;
                }
                json.addValue(key, String.valueOf(data));
            }
            json.endGroup();
            logger.debug("created json from map => " + json.toString());
            return json.toString();
        }
        catch (Exception e) {
            logger.error("Could not create JSON from Map. ", (Throwable)e);
            return "{}";
        }
    }

    private static String stringArrayFromObjectArray(Object[] data) {
        StringBuilder arrayAsString = new StringBuilder();
        for (Object o : data) {
            if (arrayAsString.length() > 0) {
                arrayAsString.append(",");
            }
            if (o instanceof Map) {
                arrayAsString.append(JsonUtility.jsonFromMap((Map)o));
                continue;
            }
            if (o instanceof JsonCapableObject) {
                arrayAsString.append(JsonUtility.jsonFromMap(((JsonCapableObject)o).jsonMap()));
                continue;
            }
            arrayAsString.append("\"").append(String.valueOf(o)).append("\"");
        }
        return arrayAsString.toString();
    }

    public static interface JsonCapableObject {
        public Map<String, Object> jsonMap();
    }

    private static class JsonDocument {
        StringBuilder json = new StringBuilder();
        private boolean newGroup = false;

        private JsonDocument() {
        }

        public JsonDocument startGroup() {
            this.newGroup = true;
            this.json.append("{");
            return this;
        }

        public JsonDocument endGroup() {
            this.json.append("}");
            return this;
        }

        public JsonDocument addValue(String key, String value) {
            if (!this.newGroup) {
                this.json.append(",");
            }
            this.newGroup = false;
            this.json.append("\"").append(key).append("\"");
            this.json.append(":");
            if (value.trim().startsWith("{") || value.trim().startsWith("[")) {
                this.json.append(value);
            } else {
                this.json.append("\"").append(value).append("\"");
            }
            return this;
        }

        public String toString() {
            return this.json.toString();
        }
    }
}

