/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import com.google.common.base.Strings;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpHeaderNames;
import com.netflix.zuul.message.http.HttpRequestInfo;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2StreamChannel;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);
    private static final char[] MALICIOUS_HEADER_CHARS = new char[]{'\r', '\n'};

    public static String getClientIP(HttpRequestInfo request) {
        String xForwardedFor = request.getHeaders().getFirst(HttpHeaderNames.X_FORWARDED_FOR);
        String clientIP = xForwardedFor == null ? request.getClientIp() : HttpUtils.extractClientIpFromXForwardedFor(xForwardedFor);
        return clientIP;
    }

    public static String extractClientIpFromXForwardedFor(String xForwardedFor) {
        if (xForwardedFor == null) {
            return null;
        }
        String[] tokenized = (xForwardedFor = xForwardedFor.trim()).split(",");
        if (tokenized.length == 0) {
            return null;
        }
        return tokenized[0].trim();
    }

    public static boolean isGzipped(String contentEncoding) {
        return contentEncoding.contains("gzip");
    }

    public static boolean isGzipped(Headers headers) {
        String ce = headers.getFirst(HttpHeaderNames.CONTENT_ENCODING);
        return ce != null && HttpUtils.isGzipped(ce);
    }

    public static boolean acceptsGzip(Headers headers) {
        String ae = headers.getFirst(HttpHeaderNames.ACCEPT_ENCODING);
        return ae != null && HttpUtils.isGzipped(ae);
    }

    public static String stripMaliciousHeaderChars(@Nullable String input) {
        if (input == null) {
            return null;
        }
        for (char c : MALICIOUS_HEADER_CHARS) {
            if (input.indexOf(c) == -1) continue;
            input = input.replace(Character.toString(c), "");
        }
        return input;
    }

    public static boolean hasNonZeroContentLengthHeader(ZuulMessage msg) {
        Integer contentLengthVal = HttpUtils.getContentLengthIfPresent(msg);
        return contentLengthVal != null && contentLengthVal > 0;
    }

    public static Integer getContentLengthIfPresent(ZuulMessage msg) {
        String contentLengthValue = msg.getHeaders().getFirst(HttpHeaderNames.CONTENT_LENGTH);
        if (!Strings.isNullOrEmpty((String)contentLengthValue)) {
            try {
                return Integer.valueOf(contentLengthValue);
            }
            catch (NumberFormatException e) {
                LOG.info("Invalid Content-Length header value on request. value = {}", (Object)contentLengthValue, (Object)e);
            }
        }
        return null;
    }

    public static Integer getBodySizeIfKnown(ZuulMessage msg) {
        Integer bodySize = HttpUtils.getContentLengthIfPresent(msg);
        if (bodySize != null) {
            return (int)bodySize;
        }
        if (msg.hasCompleteBody()) {
            return msg.getBodyLength();
        }
        return null;
    }

    public static boolean hasChunkedTransferEncodingHeader(ZuulMessage msg) {
        boolean isChunked = false;
        String teValue = msg.getHeaders().getFirst(HttpHeaderNames.TRANSFER_ENCODING);
        if (!Strings.isNullOrEmpty((String)teValue)) {
            isChunked = "chunked".equals(teValue.toLowerCase());
        }
        return isChunked;
    }

    public static Channel getMainChannel(ChannelHandlerContext ctx) {
        return HttpUtils.getMainChannel(ctx.channel());
    }

    public static Channel getMainChannel(Channel channel) {
        if (channel instanceof Http2StreamChannel) {
            return channel.parent();
        }
        return channel;
    }
}

