/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.zuul.stats.monitoring.NamedCount;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class RouteStatusCodeMonitor
implements NamedCount {
    private final String routeCode;
    @VisibleForTesting
    final String route;
    private final int statusCode;
    private final AtomicLong count = new AtomicLong();

    public RouteStatusCodeMonitor(@Nullable String route, int statusCode) {
        if (route == null) {
            route = "";
        }
        this.route = route;
        this.statusCode = statusCode;
        this.routeCode = route + "_" + statusCode;
        CompositeRegistry registry = Spectator.globalRegistry();
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withId(registry.createId("zuul.RouteStatusCodeMonitor", new String[]{"ID", this.routeCode}))).monitorValue((Object)this, RouteStatusCodeMonitor::getCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteStatusCodeMonitor statsData = (RouteStatusCodeMonitor)o;
        if (this.statusCode != statsData.statusCode) {
            return false;
        }
        return Objects.equals(this.route, statsData.route);
    }

    public int hashCode() {
        int result = this.route != null ? this.route.hashCode() : 0;
        result = 31 * result + this.statusCode;
        return result;
    }

    @Override
    public String getName() {
        return this.routeCode;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    public void update() {
        this.count.incrementAndGet();
    }
}

