/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.zuul.stats.monitoring.MonitorRegistry;
import com.netflix.zuul.stats.monitoring.NamedCount;
import java.util.concurrent.atomic.AtomicLong;

public class NamedCountingMonitor
implements NamedCount {
    private final String name;
    private final AtomicLong count = new AtomicLong();

    public NamedCountingMonitor(String name) {
        this.name = name;
        CompositeRegistry registry = Spectator.globalRegistry();
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withId(registry.createId("zuul.ErrorStatsData", new String[]{"ID", name}))).monitorValue((Object)this, NamedCountingMonitor::getCount);
    }

    public NamedCountingMonitor register() {
        MonitorRegistry.getInstance().registerObject(this);
        return this;
    }

    public long increment() {
        return this.count.incrementAndGet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }
}

