/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import com.netflix.zuul.stats.ErrorStatsData;
import com.netflix.zuul.stats.monitoring.MonitorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ErrorStatsManager {
    ConcurrentHashMap<String, ConcurrentHashMap<String, ErrorStatsData>> routeMap = new ConcurrentHashMap();
    static final ErrorStatsManager INSTANCE = new ErrorStatsManager();

    public static ErrorStatsManager getManager() {
        return INSTANCE;
    }

    public ErrorStatsData getStats(String route, String cause) {
        Map map = this.routeMap.get(route);
        if (map == null) {
            return null;
        }
        return (ErrorStatsData)map.get(cause);
    }

    public void putStats(String route, String cause) {
        ErrorStatsData sd;
        ConcurrentHashMap<String, ErrorStatsData> statsMap;
        if (route == null) {
            route = "UNKNOWN_ROUTE";
        }
        if ((statsMap = this.routeMap.get(route = route.replace("/", "_"))) == null) {
            statsMap = new ConcurrentHashMap();
            this.routeMap.putIfAbsent(route, statsMap);
        }
        if ((sd = statsMap.get(cause)) == null) {
            sd = new ErrorStatsData(route, cause);
            ErrorStatsData sd1 = statsMap.putIfAbsent(cause, sd);
            if (sd1 != null) {
                sd = sd1;
            } else {
                MonitorRegistry.getInstance().registerObject(sd);
            }
        }
        sd.update();
    }

    public static class UnitTest {
    }
}

