/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats;

import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.zuul.stats.monitoring.NamedCount;
import java.util.concurrent.atomic.AtomicLong;

public class ErrorStatsData
implements NamedCount {
    private final String id;
    private final String errorCause;
    private final AtomicLong count = new AtomicLong();

    public ErrorStatsData(String route, String cause) {
        if (null == route || "".equals(route)) {
            route = "UNKNOWN";
        }
        this.id = route + "_" + cause;
        this.errorCause = cause;
        CompositeRegistry registry = Spectator.globalRegistry();
        ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withId(registry.createId("zuul.ErrorStatsData", new String[]{"ID", this.id}))).monitorValue((Object)this, ErrorStatsData::getCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorStatsData that = (ErrorStatsData)o;
        return !(this.errorCause == null ? that.errorCause != null : !this.errorCause.equals(that.errorCause));
    }

    public int hashCode() {
        return this.errorCause != null ? this.errorCause.hashCode() : 0;
    }

    public void update() {
        this.count.incrementAndGet();
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }
}

