/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.plugins;

import com.netflix.spectator.api.Spectator;
import com.netflix.zuul.monitoring.TracerFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

public class Tracer
extends TracerFactory {
    @Override
    public com.netflix.zuul.monitoring.Tracer startMicroTracer(String name) {
        return new SpectatorTracer(name);
    }

    private static String getHostName() {
        return Tracer.loadAddress() != null ? Tracer.loadAddress().getHostName() : "unkownHost";
    }

    private static String getIp() {
        return Tracer.loadAddress() != null ? Tracer.loadAddress().getHostAddress() : "unknownHost";
    }

    private static InetAddress loadAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    class SpectatorTracer
    implements com.netflix.zuul.monitoring.Tracer {
        private String name;
        private final long start;

        private SpectatorTracer(String name) {
            this.name = name;
            this.start = System.nanoTime();
        }

        @Override
        public void stopAndLog() {
            Spectator.globalRegistry().timer(this.name, new String[]{"hostname", Tracer.getHostName(), "ip", Tracer.getIp()}).record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }
    }
}

