/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.passport;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Spectator;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;

class CountingCurrentPassport
extends CurrentPassport {
    private static final Counter IN_REQ_HEADERS_RECEIVED_CNT = CountingCurrentPassport.createCounter("in_req_hdrs_rec");
    private static final Counter IN_REQ_LAST_CONTENT_RECEIVED_CNT = CountingCurrentPassport.createCounter("in_req_last_cont_rec");
    private static final Counter IN_RESP_HEADERS_RECEIVED_CNT = CountingCurrentPassport.createCounter("in_resp_hdrs_rec");
    private static final Counter IN_RESP_LAST_CONTENT_RECEIVED_CNT = CountingCurrentPassport.createCounter("in_resp_last_cont_rec");
    private static final Counter OUT_REQ_HEADERS_SENT_CNT = CountingCurrentPassport.createCounter("out_req_hdrs_sent");
    private static final Counter OUT_REQ_LAST_CONTENT_SENT_CNT = CountingCurrentPassport.createCounter("out_req_last_cont_sent");
    private static final Counter OUT_RESP_HEADERS_SENT_CNT = CountingCurrentPassport.createCounter("out_resp_hdrs_sent");
    private static final Counter OUT_RESP_LAST_CONTENT_SENT_CNT = CountingCurrentPassport.createCounter("out_resp_last_cont_sent");

    private static Counter createCounter(String name) {
        return Spectator.globalRegistry().counter("zuul.passport." + name);
    }

    public CountingCurrentPassport() {
        this.incrementStateCounter(this.getState());
    }

    @Override
    public void add(PassportState state) {
        super.add(state);
        this.incrementStateCounter(state);
    }

    private void incrementStateCounter(PassportState state) {
        switch (state) {
            case IN_REQ_HEADERS_RECEIVED: {
                IN_REQ_HEADERS_RECEIVED_CNT.increment();
                break;
            }
            case IN_REQ_LAST_CONTENT_RECEIVED: {
                IN_REQ_LAST_CONTENT_RECEIVED_CNT.increment();
                break;
            }
            case OUT_REQ_HEADERS_SENT: {
                OUT_REQ_HEADERS_SENT_CNT.increment();
                break;
            }
            case OUT_REQ_LAST_CONTENT_SENT: {
                OUT_REQ_LAST_CONTENT_SENT_CNT.increment();
                break;
            }
            case IN_RESP_HEADERS_RECEIVED: {
                IN_RESP_HEADERS_RECEIVED_CNT.increment();
                break;
            }
            case IN_RESP_LAST_CONTENT_RECEIVED: {
                IN_RESP_LAST_CONTENT_RECEIVED_CNT.increment();
                break;
            }
            case OUT_RESP_HEADERS_SENT: {
                OUT_RESP_HEADERS_SENT_CNT.increment();
                break;
            }
            case OUT_RESP_LAST_CONTENT_SENT: {
                OUT_RESP_LAST_CONTENT_SENT_CNT.increment();
            }
        }
    }
}

