/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.origins;

import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.origins.OriginName;
import com.netflix.zuul.stats.status.StatusCategory;
import java.util.Objects;

public abstract class OriginThrottledException
extends ZuulException {
    private final OriginName originName;
    private final StatusCategory statusCategory;

    public OriginThrottledException(OriginName originName, String msg, StatusCategory statusCategory) {
        super(msg + ", origin=" + originName, true);
        this.originName = Objects.requireNonNull(originName, "originName");
        this.statusCategory = statusCategory;
        this.setStatusCode(503);
    }

    public OriginName getOriginName() {
        return this.originName;
    }

    public StatusCategory getStatusCategory() {
        return this.statusCategory;
    }
}

