/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.origins;

import com.netflix.zuul.util.VipUtils;
import java.util.Locale;
import java.util.Objects;

public final class OriginName {
    private final String niwsClientName;
    private final String metricId;
    private final String target;
    private final String authority;
    private final boolean authorityTrusted;

    public static OriginName fromVip(String vip) {
        return OriginName.fromVip(vip, vip);
    }

    public static OriginName fromVip(String vip, String niwsClientName) {
        return new OriginName(niwsClientName, vip, VipUtils.extractUntrustedAppNameFromVIP(vip), false);
    }

    private OriginName(String niwsClientName, String target, String authority, boolean authorityTrusted) {
        this.niwsClientName = Objects.requireNonNull(niwsClientName, "niwsClientName");
        this.metricId = niwsClientName.toLowerCase(Locale.ROOT);
        this.target = Objects.requireNonNull(target, "target");
        this.authority = Objects.requireNonNull(authority, "authority");
        this.authorityTrusted = authorityTrusted;
    }

    public String getTarget() {
        return this.target;
    }

    public String getNiwsClientName() {
        return this.niwsClientName;
    }

    public String getMetricId() {
        return this.metricId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OriginName)) {
            return false;
        }
        OriginName that = (OriginName)o;
        return this.authorityTrusted == that.authorityTrusted && Objects.equals(this.niwsClientName, that.niwsClientName) && Objects.equals(this.target, that.target) && Objects.equals(this.authority, that.authority);
    }

    public int hashCode() {
        return Objects.hash(this.niwsClientName, this.target, this.authority, this.authorityTrusted);
    }

    public String toString() {
        return "OriginName{niwsClientName='" + this.niwsClientName + '\'' + ", target='" + this.target + '\'' + ", authority='" + this.authority + '\'' + ", authorityTrusted=" + this.authorityTrusted + '}';
    }
}

