/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.origins;

import com.netflix.spectator.api.Registry;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.origins.BasicNettyOrigin;
import com.netflix.zuul.origins.OriginManager;
import com.netflix.zuul.origins.OriginName;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BasicNettyOriginManager
implements OriginManager<BasicNettyOrigin> {
    private final Registry registry;
    private final ConcurrentHashMap<OriginName, BasicNettyOrigin> originMappings;

    @Inject
    public BasicNettyOriginManager(Registry registry) {
        this.registry = registry;
        this.originMappings = new ConcurrentHashMap();
    }

    @Override
    public BasicNettyOrigin getOrigin(OriginName originName, String uri, SessionContext ctx) {
        return this.originMappings.computeIfAbsent(originName, n -> this.createOrigin(originName, uri, ctx));
    }

    @Override
    public BasicNettyOrigin createOrigin(OriginName originName, String uri, SessionContext ctx) {
        return new BasicNettyOrigin(originName, this.registry);
    }
}

