/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.origins;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.discovery.DiscoveryResult;
import com.netflix.zuul.exception.ErrorType;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.NettyRequestAttemptFactory;
import com.netflix.zuul.netty.SpectatorUtils;
import com.netflix.zuul.netty.connectionpool.ClientChannelManager;
import com.netflix.zuul.netty.connectionpool.DefaultClientChannelManager;
import com.netflix.zuul.netty.connectionpool.PooledConnection;
import com.netflix.zuul.niws.RequestAttempt;
import com.netflix.zuul.origins.NettyOrigin;
import com.netflix.zuul.origins.OriginConcurrencyExceededException;
import com.netflix.zuul.origins.OriginName;
import com.netflix.zuul.origins.OriginStats;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.stats.status.StatusCategory;
import com.netflix.zuul.stats.status.StatusCategoryUtils;
import com.netflix.zuul.stats.status.ZuulStatusCategory;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class BasicNettyOrigin
implements NettyOrigin {
    private final OriginName originName;
    private final Registry registry;
    private final IClientConfig config;
    private final ClientChannelManager clientChannelManager;
    private final NettyRequestAttemptFactory requestAttemptFactory;
    private final OriginStats stats = new OriginStats();
    private final AtomicInteger concurrentRequests;
    private final Counter rejectedRequests;
    private final CachedDynamicIntProperty concurrencyMax;
    private final CachedDynamicBooleanProperty concurrencyProtectionEnabled;

    public BasicNettyOrigin(OriginName originName, Registry registry) {
        this.originName = Objects.requireNonNull(originName, "originName");
        this.registry = registry;
        this.config = this.setupClientConfig(originName);
        this.clientChannelManager = new DefaultClientChannelManager(originName, this.config, registry);
        this.clientChannelManager.init();
        this.requestAttemptFactory = new NettyRequestAttemptFactory();
        String niwsClientName = this.getName().getNiwsClientName();
        this.concurrentRequests = SpectatorUtils.newGauge("zuul.origin.concurrent.requests", niwsClientName, new AtomicInteger(0));
        this.rejectedRequests = SpectatorUtils.newCounter("zuul.origin.rejected.requests", niwsClientName);
        this.concurrencyMax = new CachedDynamicIntProperty("zuul.origin." + niwsClientName + ".concurrency.max.requests", 200);
        this.concurrencyProtectionEnabled = new CachedDynamicBooleanProperty("zuul.origin." + niwsClientName + ".concurrency.protect.enabled", true);
    }

    protected IClientConfig setupClientConfig(OriginName originName) {
        DefaultClientConfigImpl niwsClientConfig = DefaultClientConfigImpl.getClientConfigWithDefaultValues((String)originName.getNiwsClientName());
        niwsClientConfig.set(CommonClientConfigKey.ClientClassName, (Object)originName.getNiwsClientName());
        niwsClientConfig.loadProperties(originName.getNiwsClientName());
        return niwsClientConfig;
    }

    @Override
    public OriginName getName() {
        return this.originName;
    }

    @Override
    public boolean isAvailable() {
        return this.clientChannelManager.isAvailable();
    }

    @Override
    public boolean isCold() {
        return this.clientChannelManager.isCold();
    }

    @Override
    public Promise<PooledConnection> connectToOrigin(HttpRequestMessage zuulReq, EventLoop eventLoop, int attemptNumber, CurrentPassport passport, AtomicReference<DiscoveryResult> chosenServer, AtomicReference<? super InetAddress> chosenHostAddr) {
        return this.clientChannelManager.acquire(eventLoop, null, passport, chosenServer, chosenHostAddr);
    }

    @Override
    public int getMaxRetriesForRequest(SessionContext context) {
        return (Integer)this.config.get(CommonClientConfigKey.MaxAutoRetriesNextServer, (Object)0);
    }

    @Override
    public RequestAttempt newRequestAttempt(DiscoveryResult server, SessionContext zuulCtx, int attemptNum) {
        return new RequestAttempt(server, this.config, attemptNum, (Integer)this.config.get(CommonClientConfigKey.ReadTimeout));
    }

    @Override
    public String getIpAddrFromServer(DiscoveryResult discoveryResult) {
        Optional ipAddr = discoveryResult.getIPAddr();
        return ipAddr.isPresent() ? (String)ipAddr.get() : null;
    }

    @Override
    public IClientConfig getClientConfig() {
        return this.config;
    }

    @Override
    public Registry getSpectatorRegistry() {
        return this.registry;
    }

    @Override
    public void recordFinalError(HttpRequestMessage requestMsg, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        SessionContext zuulCtx = requestMsg.getContext();
        ErrorType et = this.requestAttemptFactory.mapNettyToOutboundErrorType(throwable);
        StatusCategory nfs = et.getStatusCategory();
        zuulCtx.set("status_category", nfs);
        zuulCtx.set("origin_status_category", nfs);
        zuulCtx.setError(throwable);
    }

    @Override
    public void recordFinalResponse(HttpResponseMessage resp) {
        if (resp != null) {
            SessionContext zuulCtx = resp.getContext();
            int originStatusCode = resp.getStatus();
            zuulCtx.set("origin_status", originStatusCode);
            ZuulStatusCategory originNfs = ZuulStatusCategory.SUCCESS;
            if (originStatusCode == 503) {
                originNfs = ZuulStatusCategory.FAILURE_ORIGIN_THROTTLED;
            } else if (StatusCategoryUtils.isResponseHttpErrorStatus(originStatusCode)) {
                originNfs = ZuulStatusCategory.FAILURE_ORIGIN;
            }
            zuulCtx.set("origin_status_category", originNfs);
            StatusCategoryUtils.storeStatusCategoryIfNotAlreadyFailure(zuulCtx, originNfs);
        }
    }

    @Override
    public void preRequestChecks(HttpRequestMessage zuulRequest) {
        if (this.concurrencyProtectionEnabled.get() && this.concurrentRequests.get() > this.concurrencyMax.get()) {
            this.rejectedRequests.increment();
            throw new OriginConcurrencyExceededException(this.getName());
        }
        this.concurrentRequests.incrementAndGet();
    }

    @Override
    public void recordProxyRequestEnd() {
        this.concurrentRequests.decrementAndGet();
    }

    @Override
    public final OriginStats stats() {
        return this.stats;
    }

    @Override
    public double getErrorPercentage() {
        return 0.0;
    }

    @Override
    public double getErrorAllPercentage() {
        return 0.0;
    }

    @Override
    public void onRequestExecutionStart(HttpRequestMessage zuulReq) {
    }

    @Override
    public void onRequestStartWithServer(HttpRequestMessage zuulReq, DiscoveryResult discoveryResult, int attemptNum) {
    }

    @Override
    public void onRequestExceptionWithServer(HttpRequestMessage zuulReq, DiscoveryResult discoveryResult, int attemptNum, Throwable t) {
    }

    @Override
    public void onRequestExecutionSuccess(HttpRequestMessage zuulReq, HttpResponseMessage zuulResp, DiscoveryResult discoveryResult, int attemptNum) {
    }

    @Override
    public void onRequestExecutionFailed(HttpRequestMessage zuulReq, DiscoveryResult discoveryResult, int attemptNum, Throwable t) {
    }

    @Override
    public void adjustRetryPolicyIfNeeded(HttpRequestMessage zuulRequest) {
    }

    @Override
    public void recordSuccessResponse() {
    }
}

