/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.niws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.niws.RequestAttempt;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAttempts
extends ArrayList<RequestAttempt> {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAttempts.class);
    private static final ObjectMapper JACKSON_MAPPER = new ObjectMapper();

    @Nullable
    public RequestAttempt getFinalAttempt() {
        if (this.size() > 0) {
            return (RequestAttempt)this.get(this.size() - 1);
        }
        return null;
    }

    public static RequestAttempts getFromSessionContext(SessionContext ctx) {
        return (RequestAttempts)ctx.get("request_attempts");
    }

    public static RequestAttempts parse(String attemptsJson) throws IOException {
        return (RequestAttempts)JACKSON_MAPPER.readValue(attemptsJson, RequestAttempts.class);
    }

    public String toJSON() {
        ArrayNode array = JACKSON_MAPPER.createArrayNode();
        for (RequestAttempt attempt : this) {
            array.add((JsonNode)attempt.toJsonNode());
        }
        try {
            return JACKSON_MAPPER.writeValueAsString((Object)array);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error serializing RequestAttempts!", e);
        }
    }

    @Override
    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            return "";
        }
    }
}

