/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.timeouts;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.DynamicLongProperty;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.origins.NettyOrigin;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class OriginTimeoutManager {
    private final NettyOrigin origin;
    @VisibleForTesting
    static final DynamicLongProperty MAX_OUTBOUND_READ_TIMEOUT_MS = new DynamicLongProperty("zuul.origin.readtimeout.max", Duration.ofSeconds(90L).toMillis());

    public OriginTimeoutManager(NettyOrigin origin) {
        this.origin = Objects.requireNonNull(origin);
    }

    public Duration computeReadTimeout(HttpRequestMessage request, int attemptNum) {
        IClientConfig clientConfig = this.getRequestClientConfig(request);
        Long originTimeout = this.getOriginReadTimeout();
        Long requestTimeout = this.getRequestReadTimeout(clientConfig);
        long computedTimeout = originTimeout == null && requestTimeout == null ? MAX_OUTBOUND_READ_TIMEOUT_MS.get() : (originTimeout == null || requestTimeout == null ? (originTimeout == null ? requestTimeout : originTimeout) : Math.min(originTimeout, requestTimeout));
        return Duration.ofMillis(Math.min(computedTimeout, MAX_OUTBOUND_READ_TIMEOUT_MS.get()));
    }

    protected IClientConfig getRequestClientConfig(HttpRequestMessage zuulRequest) {
        IClientConfig overriddenClientConfig = (IClientConfig)zuulRequest.getContext().get("rest_client_config");
        if (overriddenClientConfig == null) {
            overriddenClientConfig = new DefaultClientConfigImpl();
            zuulRequest.getContext().put("rest_client_config", overriddenClientConfig);
        }
        return overriddenClientConfig;
    }

    @Nullable
    private Long getRequestReadTimeout(IClientConfig clientConfig) {
        return Optional.ofNullable(clientConfig.get(CommonClientConfigKey.ReadTimeout)).map(Long::valueOf).orElse(null);
    }

    @Nullable
    private Long getOriginReadTimeout() {
        return Optional.ofNullable(this.origin.getClientConfig().get(CommonClientConfigKey.ReadTimeout)).map(Long::valueOf).orElse(null);
    }
}

