/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.ssl;

import com.google.errorprone.annotations.ForOverride;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.netty.common.ssl.ServerSslConfig;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.zuul.netty.ssl.SslContextFactory;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslSessionStats;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSslContextFactory
implements SslContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BaseSslContextFactory.class);
    private static final DynamicBooleanProperty ALLOW_USE_OPENSSL = new DynamicBooleanProperty("zuul.ssl.openssl.allow", true);
    protected final Registry spectatorRegistry;
    protected final ServerSslConfig serverSslConfig;

    public BaseSslContextFactory(Registry spectatorRegistry, ServerSslConfig serverSslConfig) {
        this.spectatorRegistry = Objects.requireNonNull(spectatorRegistry);
        this.serverSslConfig = Objects.requireNonNull(serverSslConfig);
    }

    @Override
    public SslContextBuilder createBuilderForServer() {
        try {
            ArrayList<X509Certificate> trustedCerts = this.getTrustedX509Certificates();
            SslProvider sslProvider = BaseSslContextFactory.chooseSslProvider();
            LOG.debug("Using SslProvider of type {}", (Object)sslProvider.name());
            SslContextBuilder builder = this.newBuilderForServer().ciphers(this.getCiphers(), this.getCiphersFilter()).sessionTimeout(this.serverSslConfig.getSessionTimeout()).sslProvider(sslProvider);
            if (this.serverSslConfig.getClientAuth() != null && trustedCerts != null && !trustedCerts.isEmpty()) {
                builder = builder.trustManager(trustedCerts.toArray(new X509Certificate[0])).clientAuth(this.serverSslConfig.getClientAuth());
            }
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException("Error configuring SslContext!", e);
        }
    }

    /*
     * Exception decompiling
     */
    @ForOverride
    protected SslContextBuilder newBuilderForServer() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void enableSessionTickets(SslContext sslContext) {
    }

    @Override
    public void configureOpenSslStatsMetrics(SslContext sslContext, String sslContextId) {
        if (sslContext instanceof ReferenceCountedOpenSslContext) {
            OpenSslSessionStats stats = ((ReferenceCountedOpenSslContext)sslContext).sessionContext().stats();
            this.openSslStatGauge(stats, sslContextId, "accept", OpenSslSessionStats::accept);
            this.openSslStatGauge(stats, sslContextId, "accept_good", OpenSslSessionStats::acceptGood);
            this.openSslStatGauge(stats, sslContextId, "accept_renegotiate", OpenSslSessionStats::acceptRenegotiate);
            this.openSslStatGauge(stats, sslContextId, "number", OpenSslSessionStats::number);
            this.openSslStatGauge(stats, sslContextId, "connect", OpenSslSessionStats::connect);
            this.openSslStatGauge(stats, sslContextId, "connect_good", OpenSslSessionStats::connectGood);
            this.openSslStatGauge(stats, sslContextId, "connect_renegotiate", OpenSslSessionStats::connectRenegotiate);
            this.openSslStatGauge(stats, sslContextId, "hits", OpenSslSessionStats::hits);
            this.openSslStatGauge(stats, sslContextId, "cb_hits", OpenSslSessionStats::cbHits);
            this.openSslStatGauge(stats, sslContextId, "misses", OpenSslSessionStats::misses);
            this.openSslStatGauge(stats, sslContextId, "timeouts", OpenSslSessionStats::timeouts);
            this.openSslStatGauge(stats, sslContextId, "cache_full", OpenSslSessionStats::cacheFull);
            this.openSslStatGauge(stats, sslContextId, "ticket_key_fail", OpenSslSessionStats::ticketKeyFail);
            this.openSslStatGauge(stats, sslContextId, "ticket_key_new", OpenSslSessionStats::ticketKeyNew);
            this.openSslStatGauge(stats, sslContextId, "ticket_key_renew", OpenSslSessionStats::ticketKeyRenew);
            this.openSslStatGauge(stats, sslContextId, "ticket_key_resume", OpenSslSessionStats::ticketKeyResume);
        }
    }

    private void openSslStatGauge(OpenSslSessionStats stats, String sslContextId, String statName, ToDoubleFunction<OpenSslSessionStats> value) {
        Id id = this.spectatorRegistry.createId("server.ssl.stats", new String[]{"id", sslContextId, "stat", statName});
        ((PolledMeter.Builder)PolledMeter.using((Registry)this.spectatorRegistry).withId(id)).monitorValue((Object)stats, value);
        LOG.debug("Registered spectator gauge - " + id.name());
    }

    public static SslProvider chooseSslProvider() {
        SslProvider sslProvider = ALLOW_USE_OPENSSL.get() && OpenSsl.isAvailable() && SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
        return sslProvider;
    }

    public ServerSslConfig getServerSslConfig() {
        return this.serverSslConfig;
    }

    @Override
    public String[] getProtocols() {
        return this.serverSslConfig.getProtocols();
    }

    @Override
    public List<String> getCiphers() throws NoSuchAlgorithmException {
        return this.serverSslConfig.getCiphers();
    }

    protected CipherSuiteFilter getCiphersFilter() {
        return SupportedCipherSuiteFilter.INSTANCE;
    }

    protected ArrayList<X509Certificate> getTrustedX509Certificates() throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
        if (this.serverSslConfig.getClientAuth() == ClientAuth.REQUIRE || this.serverSslConfig.getClientAuth() == ClientAuth.OPTIONAL) {
            byte[] trustStorePwdBytes;
            if (this.serverSslConfig.getClientAuthTrustStorePassword() != null) {
                trustStorePwdBytes = Base64.getDecoder().decode(this.serverSslConfig.getClientAuthTrustStorePassword());
            } else if (this.serverSslConfig.getClientAuthTrustStorePasswordFile() != null) {
                trustStorePwdBytes = Files.readAllBytes(this.serverSslConfig.getClientAuthTrustStorePasswordFile().toPath());
            } else {
                throw new IllegalArgumentException("Must specify either ClientAuthTrustStorePassword or ClientAuthTrustStorePasswordFile!");
            }
            String trustStorePassword = this.getTruststorePassword(trustStorePwdBytes);
            boolean dumpDecryptedTrustStorePassword = false;
            if (dumpDecryptedTrustStorePassword) {
                LOG.debug("X509Cert Trust Store Password " + trustStorePassword);
            }
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(new FileInputStream(this.serverSslConfig.getClientAuthTrustStoreFile()), trustStorePassword.toCharArray());
            Enumeration<String> aliases = trustStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate cert = (X509Certificate)trustStore.getCertificate(aliases.nextElement());
                trustedCerts.add(cert);
            }
        }
        return trustedCerts;
    }

    protected String getTruststorePassword(byte[] trustStorePwdBytes) {
        return new String(trustStorePwdBytes).trim();
    }

    protected InputStream getKeyInputStream() throws IOException {
        return new FileInputStream(this.serverSslConfig.getKeyFile());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

