/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.ssl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.netty.common.ssl.SslHandshakeInfo;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AttributeKey;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslHandshakeInfoHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<SslHandshakeInfo> ATTR_SSL_INFO = AttributeKey.newInstance((String)"_ssl_handshake_info");
    private static final Logger logger = LoggerFactory.getLogger(SslHandshakeInfoHandler.class);
    private final Registry spectatorRegistry;
    private final boolean isSSlFromIntermediary;

    public SslHandshakeInfoHandler(Registry spectatorRegistry, boolean isSSlFromIntermediary) {
        this.spectatorRegistry = (Registry)Preconditions.checkNotNull((Object)spectatorRegistry);
        this.isSSlFromIntermediary = isSSlFromIntermediary;
    }

    @VisibleForTesting
    SslHandshakeInfoHandler() {
        this.spectatorRegistry = null;
        this.isSSlFromIntermediary = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            try {
                SslHandshakeCompletionEvent sslEvent = (SslHandshakeCompletionEvent)evt;
                if (sslEvent.isSuccess()) {
                    CurrentPassport.fromChannel(ctx.channel()).add(PassportState.SERVER_CH_SSL_HANDSHAKE_COMPLETE);
                    SslHandler sslhandler = (SslHandler)ctx.channel().pipeline().get(SslHandler.class);
                    SSLSession session = sslhandler.engine().getSession();
                    ClientAuth clientAuth = this.whichClientAuthEnum(sslhandler);
                    Certificate serverCert = null;
                    X509Certificate peerCert = null;
                    if ((clientAuth == ClientAuth.REQUIRE || clientAuth == ClientAuth.OPTIONAL) && session.getPeerCertificates() != null && session.getPeerCertificates().length > 0) {
                        peerCert = (X509Certificate)session.getPeerCertificates()[0];
                    }
                    if (session.getLocalCertificates() != null && session.getLocalCertificates().length > 0) {
                        serverCert = session.getLocalCertificates()[0];
                    }
                    SslHandshakeInfo info = new SslHandshakeInfo(this.isSSlFromIntermediary, session.getProtocol(), session.getCipherSuite(), clientAuth, serverCert, peerCert);
                    ctx.channel().attr(ATTR_SSL_INFO).set((Object)info);
                    this.incrementCounters(sslEvent, info);
                    logger.debug("Successful SSL Handshake: {}", (Object)info);
                }
                String clientIP = (String)ctx.channel().attr(SourceAddressChannelHandler.ATTR_SOURCE_ADDRESS).get();
                Throwable cause = sslEvent.cause();
                PassportState passportState = CurrentPassport.fromChannel(ctx.channel()).getState();
                if (cause instanceof ClosedChannelException && (PassportState.SERVER_CH_INACTIVE.equals((Object)passportState) || PassportState.SERVER_CH_IDLE_TIMEOUT.equals((Object)passportState))) {
                    logger.debug("Client closed connection or it idle timed-out without doing an ssl handshake. , client_ip = " + clientIP + ", channel_info = " + ChannelUtils.channelInfoForLogging(ctx.channel()));
                }
                if (cause instanceof SSLException && cause.getMessage().contains("handshake timed out")) {
                    logger.debug("Client timed-out doing the ssl handshake. , client_ip = " + clientIP + ", channel_info = " + ChannelUtils.channelInfoForLogging(ctx.channel()));
                }
                if (cause instanceof SSLException && cause.getMessage().contains("failure when writing TLS control frames")) {
                    logger.debug("Client terminated handshake early., client_ip = " + clientIP + ", channel_info = " + ChannelUtils.channelInfoForLogging(ctx.channel()));
                }
                String msg = "Unsuccessful SSL Handshake: " + sslEvent + ", client_ip = " + clientIP + ", channel_info = " + ChannelUtils.channelInfoForLogging(ctx.channel()) + ", error = " + cause;
                if (cause instanceof ClosedChannelException) {
                    logger.debug(msg);
                } else {
                    logger.debug(msg, cause);
                }
                this.incrementCounters(sslEvent, null);
            }
            catch (Throwable e) {
                logger.warn("Error getting the SSL handshake info.", e);
            }
            finally {
                ctx.pipeline().remove((ChannelHandler)this);
            }
        } else if (!(evt instanceof SslCloseCompletionEvent) && evt instanceof SniCompletionEvent) {
            logger.debug("SNI Parsing Complete: {}", evt);
            SniCompletionEvent sniCompletionEvent = (SniCompletionEvent)evt;
            if (sniCompletionEvent.isSuccess()) {
                this.spectatorRegistry.counter("zuul.sni.parse.success").increment();
            } else {
                Throwable cause = sniCompletionEvent.cause();
                this.spectatorRegistry.counter("zuul.sni.parse.failure", new String[]{cause != null ? cause.getMessage() : "UNKNOWN"}).increment();
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    private ClientAuth whichClientAuthEnum(SslHandler sslhandler) {
        ClientAuth clientAuth = sslhandler.engine().getNeedClientAuth() ? ClientAuth.REQUIRE : (sslhandler.engine().getWantClientAuth() ? ClientAuth.OPTIONAL : ClientAuth.NONE);
        return clientAuth;
    }

    private void incrementCounters(SslHandshakeCompletionEvent sslHandshakeCompletionEvent, SslHandshakeInfo handshakeInfo) {
        if (this.spectatorRegistry == null) {
            return;
        }
        try {
            if (sslHandshakeCompletionEvent.isSuccess()) {
                String proto = handshakeInfo.getProtocol().length() > 0 ? handshakeInfo.getProtocol() : "unknown";
                String ciphsuite = handshakeInfo.getCipherSuite().length() > 0 ? handshakeInfo.getCipherSuite() : "unknown";
                this.spectatorRegistry.counter("server.ssl.handshake", new String[]{"success", String.valueOf(sslHandshakeCompletionEvent.isSuccess()), "protocol", String.valueOf(proto), "ciphersuite", String.valueOf(ciphsuite), "clientauth", String.valueOf(handshakeInfo.getClientAuthRequirement())}).increment();
            } else {
                this.spectatorRegistry.counter("server.ssl.handshake", new String[]{"success", String.valueOf(sslHandshakeCompletionEvent.isSuccess()), "failure_cause", String.valueOf(sslHandshakeCompletionEvent.cause())}).increment();
            }
        }
        catch (Exception e) {
            logger.error("Error incrememting counters for SSL handshake!", (Throwable)e);
        }
    }
}

