/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.push;

import com.google.common.base.Strings;
import com.netflix.zuul.netty.server.push.PushConnection;
import com.netflix.zuul.netty.server.push.PushConnectionRegistry;
import com.netflix.zuul.netty.server.push.PushUserAuth;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ChannelHandler.Sharable
public abstract class PushMessageSender
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final PushConnectionRegistry pushConnectionRegistry;
    public static final String SECURE_TOKEN_HEADER_NAME = "X-Zuul.push.secure.token";
    private static final Logger logger = LoggerFactory.getLogger(PushMessageSender.class);

    @Inject
    public PushMessageSender(PushConnectionRegistry pushConnectionRegistry) {
        this.pushConnectionRegistry = pushConnectionRegistry;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest request, HttpResponseStatus status, PushUserAuth userAuth) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        resp.headers().add("Content-Length", (Object)"0");
        ChannelFuture cf = ctx.channel().writeAndFlush((Object)resp);
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            cf.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.logPushEvent(request, status, userAuth);
    }

    protected boolean verifySecureToken(FullHttpRequest request, PushConnection conn) {
        String secureToken = request.headers().get(SECURE_TOKEN_HEADER_NAME);
        if (Strings.isNullOrEmpty((String)secureToken)) {
            return true;
        }
        return secureToken.equals(conn.getSecureToken());
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        if (!request.decoderResult().isSuccess()) {
            this.sendHttpResponse(ctx, request, HttpResponseStatus.BAD_REQUEST, null);
            return;
        }
        String path = request.uri();
        if (path == null) {
            this.sendHttpResponse(ctx, request, HttpResponseStatus.BAD_REQUEST, null);
            return;
        }
        if (path.endsWith("/push")) {
            this.logPushAttempt();
            HttpMethod method = request.method();
            if (method != HttpMethod.POST && method != HttpMethod.GET) {
                this.sendHttpResponse(ctx, request, HttpResponseStatus.METHOD_NOT_ALLOWED, null);
                return;
            }
            PushUserAuth userAuth = this.getPushUserAuth(request);
            if (!userAuth.isSuccess()) {
                this.sendHttpResponse(ctx, request, HttpResponseStatus.UNAUTHORIZED, userAuth);
                this.logNoIdentity();
                return;
            }
            PushConnection pushConn = this.pushConnectionRegistry.get(userAuth.getClientIdentity());
            if (pushConn == null) {
                this.sendHttpResponse(ctx, request, HttpResponseStatus.NOT_FOUND, userAuth);
                this.logClientNotConnected();
                return;
            }
            if (!this.verifySecureToken(request, pushConn)) {
                this.sendHttpResponse(ctx, request, HttpResponseStatus.FORBIDDEN, userAuth);
                this.logSecurityTokenVerificationFail();
                return;
            }
            if (method == HttpMethod.GET) {
                this.sendHttpResponse(ctx, request, HttpResponseStatus.OK, userAuth);
                return;
            }
            ByteBuf body = request.content().retain();
            if (body.readableBytes() <= 0) {
                this.sendHttpResponse(ctx, request, HttpResponseStatus.NO_CONTENT, userAuth);
                return;
            }
            if (pushConn.isRateLimited()) {
                this.sendHttpResponse(ctx, request, HttpResponseStatus.SERVICE_UNAVAILABLE, userAuth);
                this.logRateLimited();
                return;
            }
            ChannelFuture clientFuture = pushConn.sendPushMessage(body);
            clientFuture.addListener(cf -> {
                HttpResponseStatus status;
                if (cf.isSuccess()) {
                    this.logPushSuccess();
                    status = HttpResponseStatus.OK;
                } else {
                    this.logPushError(cf.cause());
                    status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                }
                this.sendHttpResponse(ctx, request, status, userAuth);
            });
        } else {
            this.sendHttpResponse(ctx, request, HttpResponseStatus.BAD_REQUEST, null);
        }
    }

    protected void logPushAttempt() {
        logger.debug("pushing notification");
    }

    protected void logNoIdentity() {
        logger.debug("push notification missing identity");
    }

    protected void logClientNotConnected() {
        logger.debug("push notification, client not connected");
    }

    protected void logPushSuccess() {
        logger.debug("push notification success");
    }

    protected void logPushError(Throwable t) {
        logger.debug("pushing notification error", t);
    }

    protected void logRateLimited() {
        logger.warn("Push message was rejected because of the rate limiting");
    }

    protected void logSecurityTokenVerificationFail() {
        logger.warn("Push secure token verification failed");
    }

    protected void logPushEvent(FullHttpRequest request, HttpResponseStatus status, PushUserAuth userAuth) {
        logger.debug("Push notification status: {}, auth: {}", (Object)status.code(), userAuth != null ? userAuth : "-");
    }

    protected abstract PushUserAuth getPushUserAuth(FullHttpRequest var1);
}

