/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.push;

import com.netflix.zuul.netty.server.push.PushConnection;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PushConnectionRegistry {
    private final ConcurrentMap<String, PushConnection> clientPushConnectionMap = new ConcurrentHashMap<String, PushConnection>(32768);
    private final SecureRandom secureTokenGenerator = new SecureRandom();

    @Inject
    private PushConnectionRegistry() {
    }

    public PushConnection get(String clientId) {
        return (PushConnection)this.clientPushConnectionMap.get(clientId);
    }

    public String mintNewSecureToken() {
        byte[] tokenBuffer = new byte[15];
        this.secureTokenGenerator.nextBytes(tokenBuffer);
        return Base64.getUrlEncoder().encodeToString(tokenBuffer);
    }

    public void put(String clientId, PushConnection pushConnection) {
        pushConnection.setSecureToken(this.mintNewSecureToken());
        this.clientPushConnectionMap.put(clientId, pushConnection);
    }

    public PushConnection remove(String clientId) {
        PushConnection pc = (PushConnection)this.clientPushConnectionMap.remove(clientId);
        return pc;
    }

    public int size() {
        return this.clientPushConnectionMap.size();
    }
}

