/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.http2;

import com.netflix.netty.common.Http2ConnectionCloseHandler;
import com.netflix.netty.common.Http2ConnectionExpiryHandler;
import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.netty.common.metrics.Http2MetricsChannelHandlers;
import com.netflix.netty.common.proxyprotocol.HAProxyMessageChannelHandler;
import com.netflix.zuul.netty.server.BaseZuulChannelInitializer;
import com.netflix.zuul.netty.server.http2.Http2ContentLengthEnforcingHandler;
import com.netflix.zuul.netty.server.http2.Http2OrHttpHandler;
import com.netflix.zuul.netty.server.http2.Http2ResetFrameHandler;
import com.netflix.zuul.netty.server.http2.Http2StreamErrorHandler;
import com.netflix.zuul.netty.server.http2.Http2StreamHeaderCleaner;
import com.netflix.zuul.netty.server.ssl.SslHandshakeInfoHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.util.AttributeKey;
import java.util.function.Consumer;

@ChannelHandler.Sharable
public class Http2StreamInitializer
extends ChannelInboundHandlerAdapter {
    private static final Http2StreamHeaderCleaner http2StreamHeaderCleaner = new Http2StreamHeaderCleaner();
    private static final Http2ResetFrameHandler http2ResetFrameHandler = new Http2ResetFrameHandler();
    private static final Http2StreamErrorHandler http2StreamErrorHandler = new Http2StreamErrorHandler();
    private final Channel parent;
    private final Consumer<ChannelPipeline> addHttpHandlerFn;
    private final Http2MetricsChannelHandlers http2MetricsChannelHandlers;
    private final Http2ConnectionCloseHandler connectionCloseHandler;
    private final Http2ConnectionExpiryHandler connectionExpiryHandler;

    public Http2StreamInitializer(Channel parent, Consumer<ChannelPipeline> addHttpHandlerFn, Http2MetricsChannelHandlers http2MetricsChannelHandlers, Http2ConnectionCloseHandler connectionCloseHandler, Http2ConnectionExpiryHandler connectionExpiryHandler) {
        this.parent = parent;
        this.addHttpHandlerFn = addHttpHandlerFn;
        this.http2MetricsChannelHandlers = http2MetricsChannelHandlers;
        this.connectionCloseHandler = connectionCloseHandler;
        this.connectionExpiryHandler = connectionExpiryHandler;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.copyAttrsFromParentChannel(this.parent, ctx.channel());
        this.addHttp2StreamSpecificHandlers(ctx.pipeline());
        this.addHttpHandlerFn.accept(ctx.pipeline());
        ctx.pipeline().remove((ChannelHandler)this);
    }

    protected void addHttp2StreamSpecificHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("h2_metrics_inbound", (ChannelHandler)this.http2MetricsChannelHandlers.inbound());
        pipeline.addLast("h2_metrics_outbound", (ChannelHandler)this.http2MetricsChannelHandlers.outbound());
        pipeline.addLast("h2_max_requests_per_conn", (ChannelHandler)this.connectionExpiryHandler);
        pipeline.addLast("h2_conn_close", (ChannelHandler)this.connectionCloseHandler);
        pipeline.addLast(new ChannelHandler[]{http2ResetFrameHandler});
        pipeline.addLast("h2_downgrader", (ChannelHandler)new Http2StreamFrameToHttpObjectCodec(true));
        pipeline.addLast(new ChannelHandler[]{http2StreamErrorHandler});
        pipeline.addLast(new ChannelHandler[]{http2StreamHeaderCleaner});
        pipeline.addLast(new ChannelHandler[]{new Http2ContentLengthEnforcingHandler()});
    }

    protected void copyAttrsFromParentChannel(Channel parent, Channel child) {
        AttributeKey[] attributesToCopy;
        for (AttributeKey key : attributesToCopy = new AttributeKey[]{SourceAddressChannelHandler.ATTR_LOCAL_ADDRESS, SourceAddressChannelHandler.ATTR_LOCAL_INET_ADDR, SourceAddressChannelHandler.ATTR_SOURCE_ADDRESS, SourceAddressChannelHandler.ATTR_SOURCE_INET_ADDR, SourceAddressChannelHandler.ATTR_SERVER_LOCAL_ADDRESS, SourceAddressChannelHandler.ATTR_SERVER_LOCAL_PORT, SourceAddressChannelHandler.ATTR_PROXY_PROTOCOL_DESTINATION_ADDRESS, Http2OrHttpHandler.PROTOCOL_NAME, SslHandshakeInfoHandler.ATTR_SSL_INFO, HAProxyMessageChannelHandler.ATTR_HAPROXY_MESSAGE, HAProxyMessageChannelHandler.ATTR_HAPROXY_VERSION, BaseZuulChannelInitializer.ATTR_CHANNEL_CONFIG}) {
            this.copyAttrFromParentChannel(parent, child, key);
        }
    }

    protected void copyAttrFromParentChannel(Channel parent, Channel child, AttributeKey key) {
        child.attr(key).set(parent.attr(key).get());
    }
}

