/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.http2;

import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.netty.common.http2.DynamicHttp2FrameLogger;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.UniformStreamByteDistributor;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.util.AttributeKey;
import java.util.function.Consumer;

public class Http2OrHttpHandler
extends ApplicationProtocolNegotiationHandler {
    public static final AttributeKey<String> PROTOCOL_NAME = AttributeKey.valueOf((String)"protocol_name");
    private static final DynamicHttp2FrameLogger FRAME_LOGGER = new DynamicHttp2FrameLogger(LogLevel.DEBUG, Http2FrameCodec.class);
    private final ChannelHandler http2StreamHandler;
    private final int maxConcurrentStreams;
    private final int initialWindowSize;
    private final long maxHeaderTableSize;
    private final long maxHeaderListSize;
    private final Consumer<ChannelPipeline> addHttpHandlerFn;

    public Http2OrHttpHandler(ChannelHandler http2StreamHandler, ChannelConfig channelConfig, Consumer<ChannelPipeline> addHttpHandlerFn) {
        super("http/1.1");
        this.http2StreamHandler = http2StreamHandler;
        this.maxConcurrentStreams = channelConfig.get(CommonChannelConfigKeys.maxConcurrentStreams);
        this.initialWindowSize = channelConfig.get(CommonChannelConfigKeys.initialWindowSize);
        this.maxHeaderTableSize = channelConfig.get(CommonChannelConfigKeys.maxHttp2HeaderTableSize).intValue();
        this.maxHeaderListSize = channelConfig.get(CommonChannelConfigKeys.maxHttp2HeaderListSize).intValue();
        this.addHttpHandlerFn = addHttpHandlerFn;
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        if ("h2".equals(protocol)) {
            ctx.channel().attr(PROTOCOL_NAME).set((Object)"HTTP/2");
            this.configureHttp2(ctx.pipeline());
            return;
        }
        if ("http/1.1".equals(protocol)) {
            ctx.channel().attr(PROTOCOL_NAME).set((Object)"HTTP/1.1");
            this.configureHttp1(ctx.pipeline());
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    private void configureHttp2(ChannelPipeline pipeline) {
        Http2Settings settings = new Http2Settings().maxConcurrentStreams((long)this.maxConcurrentStreams).initialWindowSize(this.initialWindowSize).headerTableSize(this.maxHeaderTableSize).maxHeaderListSize(this.maxHeaderListSize);
        Http2FrameCodec frameCodec = Http2FrameCodecBuilder.forServer().frameLogger((Http2FrameLogger)FRAME_LOGGER).initialSettings(settings).validateHeaders(true).build();
        Http2Connection conn = frameCodec.connection();
        conn.remote().flowController((Http2FlowController)new DefaultHttp2RemoteFlowController(conn, (StreamByteDistributor)new UniformStreamByteDistributor(conn)));
        Http2MultiplexHandler multiplexHandler = new Http2MultiplexHandler(this.http2StreamHandler);
        pipeline.addBefore("codec_placeholder", null, (ChannelHandler)frameCodec);
        pipeline.replace("codec_placeholder", "codec", (ChannelHandler)multiplexHandler);
    }

    private void configureHttp1(ChannelPipeline pipeline) {
        this.addHttpHandlerFn.accept(pipeline);
    }
}

