/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2Error;
import java.util.List;

public final class Http2ContentLengthEnforcingHandler
extends ChannelInboundHandlerAdapter {
    private static final long UNSET_CONTENT_LENGTH = -1L;
    private long expectedContentLength = -1L;
    private long seenContentLength;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            List lengthHeaders = req.headers().getAll((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (lengthHeaders.size() > 1) {
                ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR));
                return;
            }
            if (lengthHeaders.size() == 1) {
                this.expectedContentLength = Long.parseLong((String)lengthHeaders.get(0));
                if (this.expectedContentLength < 0L) {
                    ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR));
                    return;
                }
            }
            if (this.hasContentLength() && HttpUtil.isTransferEncodingChunked((HttpMessage)req)) {
                ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR));
                return;
            }
        }
        if (msg instanceof HttpContent) {
            ByteBuf content = ((HttpContent)msg).content();
            this.incrementSeenContent(content.readableBytes());
            if (this.hasContentLength() && this.seenContentLength > this.expectedContentLength) {
                ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR));
                return;
            }
        }
        if (msg instanceof LastHttpContent && this.hasContentLength() && this.seenContentLength != this.expectedContentLength) {
            ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR));
            return;
        }
        super.channelRead(ctx, msg);
    }

    private boolean hasContentLength() {
        return this.expectedContentLength != -1L;
    }

    private void incrementSeenContent(int length) {
        this.seenContentLength = Math.addExact(this.seenContentLength, (long)length);
    }
}

