/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.http2;

import com.netflix.zuul.netty.ssl.SslContextFactory;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import javax.net.ssl.SSLException;

public class Http2Configuration {
    public static SslContext configureSSL(SslContextFactory sslContextFactory, String metricId) {
        SslContext sslContext;
        SslContextBuilder builder = sslContextFactory.createBuilderForServer();
        String[] supportedProtocols = new String[]{"h2", "http/1.1"};
        ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocols);
        try {
            sslContext = builder.applicationProtocolConfig(apn).build();
        }
        catch (SSLException e) {
            throw new RuntimeException("Error configuring SslContext with ALPN!", e);
        }
        sslContextFactory.enableSessionTickets(sslContext);
        sslContextFactory.configureOpenSslStatsMetrics(sslContext, metricId);
        return sslContext;
    }

    public static SslContext configureSSLWithH2Disabled(SslContextFactory sslContextFactory, String host) {
        SslContext sslContext;
        ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"http/1.1"});
        try {
            sslContext = sslContextFactory.createBuilderForServer().applicationProtocolConfig(apn).build();
        }
        catch (SSLException e) {
            throw new RuntimeException("Error configuring SslContext with ALPN!", e);
        }
        sslContextFactory.enableSessionTickets(sslContext);
        sslContextFactory.configureOpenSslStatsMetrics(sslContext, host);
        return sslContext;
    }
}

