/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.netflix.config.StringDerivedProperty;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class SocketAddressProperty
extends StringDerivedProperty<SocketAddress> {
    public SocketAddressProperty(String propName, SocketAddress defaultValue) {
        super(propName, (Object)defaultValue, (Function)Decoder.INSTANCE);
    }

    public SocketAddressProperty(String propName, String defaultValue) {
        this(propName, Decoder.INSTANCE.apply(defaultValue));
    }

    @VisibleForTesting
    static final class Decoder
    implements Function<String, SocketAddress> {
        static final Decoder INSTANCE = new Decoder();

        Decoder() {
        }

        public SocketAddress apply(String input) {
            int port;
            if (input == null || input.isEmpty()) {
                throw new IllegalArgumentException("Invalid address");
            }
            int equalsPosition = input.indexOf(61);
            if (equalsPosition == -1) {
                throw new IllegalArgumentException("Invalid address " + input);
            }
            String rawBindType = equalsPosition != 0 ? input.substring(0, equalsPosition) : BindType.ANY.name();
            BindType bindType = BindType.valueOf(rawBindType.toUpperCase(Locale.ROOT));
            String rawAddress = input.substring(equalsPosition + 1);
            switch (bindType) {
                case ANY: 
                case IPV4_ANY: 
                case IPV6_ANY: 
                case ANY_LOCAL: 
                case IPV4_LOCAL: 
                case IPV6_LOCAL: {
                    try {
                        port = Integer.parseInt(rawAddress);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid Port " + input, e);
                    }
                }
                case UDS: {
                    port = -1;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Missed cased: " + (Object)((Object)bindType)));
                }
            }
            switch (bindType) {
                case ANY: {
                    return new InetSocketAddress(port);
                }
                case IPV4_ANY: 
                case IPV6_ANY: 
                case ANY_LOCAL: 
                case IPV4_LOCAL: 
                case IPV6_LOCAL: {
                    return new InetSocketAddress((InetAddress)bindType.addressSupplier.get(), port);
                }
                case UDS: {
                    return new DomainSocketAddress(rawAddress);
                }
            }
            throw new AssertionError((Object)("Missed cased: " + (Object)((Object)bindType)));
        }

        public boolean equals(Object object) {
            return false;
        }
    }

    public static enum BindType {
        ANY,
        IPV4_ANY(() -> InetAddress.getByAddress("0.0.0.0", new byte[]{0, 0, 0, 0})),
        IPV6_ANY(() -> InetAddress.getByAddress("::", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0})),
        ANY_LOCAL(InetAddress::getLoopbackAddress),
        IPV4_LOCAL(() -> InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1})),
        IPV6_LOCAL(() -> InetAddress.getByAddress("localhost", new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1})),
        UDS;

        @Nullable
        private final Supplier<? extends InetAddress> addressSupplier;

        private BindType() {
            this.addressSupplier = null;
        }

        private BindType(Callable<? extends InetAddress> addressFn) {
            this.addressSupplier = () -> {
                try {
                    return (InetAddress)addressFn.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
    }
}

