/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.netty.common.CategorizedThreadFactory;
import com.netflix.netty.common.LeastConnsEventLoopChooserFactory;
import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import com.netflix.netty.common.status.ServerStatusManager;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.patterns.PolledMeter;
import com.netflix.zuul.Attrs;
import com.netflix.zuul.monitoring.ConnCounter;
import com.netflix.zuul.monitoring.ConnTimer;
import com.netflix.zuul.netty.server.ClientConnectionsShutdown;
import com.netflix.zuul.netty.server.DefaultEventLoopConfig;
import com.netflix.zuul.netty.server.EventLoopConfig;
import com.netflix.zuul.netty.server.NamedSocketAddress;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.lang.constant.Constable;
import java.net.InetSocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    @Deprecated
    public static final DynamicBooleanProperty USE_EPOLL = new DynamicBooleanProperty("zuul.server.netty.socket.epoll", false);
    private static final DynamicBooleanProperty FORCE_NIO = new DynamicBooleanProperty("zuul.server.netty.socket.force_nio", false);
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private static final DynamicBooleanProperty USE_LEASTCONNS_FOR_EVENTLOOPS = new DynamicBooleanProperty("zuul.server.eventloops.use_leastconns", false);
    private static final DynamicBooleanProperty MANUAL_DISCOVERY_STATUS = new DynamicBooleanProperty("zuul.server.netty.manual.discovery.status", true);
    private final EventLoopGroupMetrics eventLoopGroupMetrics;
    private final Thread jvmShutdownHook = new Thread(this::stop, "Zuul-JVM-shutdown-hook");
    private final Registry registry;
    private ServerGroup serverGroup;
    private final ClientConnectionsShutdown clientConnectionsShutdown;
    private final ServerStatusManager serverStatusManager;
    private final Map<NamedSocketAddress, ? extends ChannelInitializer<?>> addressesToInitializers;
    private final Map<NamedSocketAddress, Channel> addressesToChannels = new LinkedHashMap<NamedSocketAddress, Channel>();
    private final EventLoopConfig eventLoopConfig;
    @Deprecated
    public static final AtomicReference<Class<? extends Channel>> defaultOutboundChannelType = new AtomicReference();
    public static final AttributeKey<Attrs> CONN_DIMENSIONS = AttributeKey.newInstance((String)"zuulconndimensions");

    @Deprecated
    public Server(Map<Integer, ChannelInitializer> portsToChannelInitializers, ServerStatusManager serverStatusManager, ClientConnectionsShutdown clientConnectionsShutdown, EventLoopGroupMetrics eventLoopGroupMetrics) {
        this(portsToChannelInitializers, serverStatusManager, clientConnectionsShutdown, eventLoopGroupMetrics, new DefaultEventLoopConfig());
    }

    @Deprecated
    public Server(Map<Integer, ChannelInitializer> portsToChannelInitializers, ServerStatusManager serverStatusManager, ClientConnectionsShutdown clientConnectionsShutdown, EventLoopGroupMetrics eventLoopGroupMetrics, EventLoopConfig eventLoopConfig) {
        this((Registry)Spectator.globalRegistry(), serverStatusManager, Server.convertPortMap(portsToChannelInitializers), clientConnectionsShutdown, eventLoopGroupMetrics, eventLoopConfig);
    }

    public Server(Registry registry, ServerStatusManager serverStatusManager, Map<NamedSocketAddress, ? extends ChannelInitializer<?>> addressesToInitializers, ClientConnectionsShutdown clientConnectionsShutdown, EventLoopGroupMetrics eventLoopGroupMetrics, EventLoopConfig eventLoopConfig) {
        this.registry = Objects.requireNonNull(registry);
        this.addressesToInitializers = Collections.unmodifiableMap(new LinkedHashMap(addressesToInitializers));
        this.serverStatusManager = (ServerStatusManager)Preconditions.checkNotNull((Object)serverStatusManager, (Object)"serverStatusManager");
        this.clientConnectionsShutdown = (ClientConnectionsShutdown)Preconditions.checkNotNull((Object)clientConnectionsShutdown, (Object)"clientConnectionsShutdown");
        this.eventLoopConfig = (EventLoopConfig)Preconditions.checkNotNull((Object)eventLoopConfig, (Object)"eventLoopConfig");
        this.eventLoopGroupMetrics = (EventLoopGroupMetrics)Preconditions.checkNotNull((Object)eventLoopGroupMetrics, (Object)"eventLoopGroupMetrics");
    }

    public void stop() {
        LOG.info("Shutting down Zuul.");
        this.serverGroup.stop();
        try {
            Runtime.getRuntime().removeShutdownHook(this.jvmShutdownHook);
        }
        catch (IllegalStateException e) {
            LOG.debug("Failed to remove shutdown hook", (Throwable)e);
        }
        LOG.info("Completed zuul shutdown.");
    }

    public void start() {
        this.serverGroup = new ServerGroup("Salamander", this.eventLoopConfig.acceptorCount(), this.eventLoopConfig.eventLoopCount(), this.eventLoopGroupMetrics);
        this.serverGroup.initializeTransport();
        try {
            ArrayList<ChannelFuture> allBindFutures = new ArrayList<ChannelFuture>(this.addressesToInitializers.size());
            for (Map.Entry<NamedSocketAddress, ChannelInitializer<?>> entry : this.addressesToInitializers.entrySet()) {
                NamedSocketAddress requestedNamedAddr = entry.getKey();
                ChannelFuture nettyServerFuture = this.setupServerBootstrap(requestedNamedAddr, entry.getValue());
                Channel chan = nettyServerFuture.channel();
                this.addressesToChannels.put(requestedNamedAddr.withNewSocket(chan.localAddress()), chan);
                allBindFutures.add(nettyServerFuture);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public final void awaitTermination() throws InterruptedException {
        for (Channel chan : this.addressesToChannels.values()) {
            chan.closeFuture().sync();
        }
    }

    public final List<NamedSocketAddress> getListeningAddresses() {
        if (this.serverGroup == null) {
            throw new IllegalStateException("Server has not been started");
        }
        return Collections.unmodifiableList(new ArrayList<NamedSocketAddress>(this.addressesToChannels.keySet()));
    }

    @VisibleForTesting
    public void waitForEachEventLoop() throws InterruptedException, ExecutionException {
        for (EventExecutor exec : this.serverGroup.clientToProxyWorkerPool) {
            exec.submit(() -> {}).get();
        }
    }

    @VisibleForTesting
    public void gracefullyShutdownConnections() {
        this.clientConnectionsShutdown.gracefullyShutdownClientChannels();
    }

    private ChannelFuture setupServerBootstrap(NamedSocketAddress listenAddress, ChannelInitializer<?> channelInitializer) throws InterruptedException {
        ChannelFuture bindFuture;
        ByteBufAllocator alloc;
        ServerBootstrap serverBootstrap = new ServerBootstrap().group(this.serverGroup.clientToProxyBossPool, this.serverGroup.clientToProxyWorkerPool);
        HashMap<ChannelOption, Constable> channelOptions = new HashMap<ChannelOption, Constable>();
        channelOptions.put(ChannelOption.SO_BACKLOG, Integer.valueOf(128));
        channelOptions.put(ChannelOption.SO_LINGER, Integer.valueOf(-1));
        channelOptions.put(ChannelOption.TCP_NODELAY, Boolean.valueOf(true));
        channelOptions.put(ChannelOption.SO_KEEPALIVE, Boolean.valueOf(true));
        LOG.info("Proxy listening with " + this.serverGroup.channelType);
        serverBootstrap.channel(this.serverGroup.channelType);
        for (Map.Entry optionEntry : channelOptions.entrySet()) {
            serverBootstrap = (ServerBootstrap)serverBootstrap.option((ChannelOption)optionEntry.getKey(), optionEntry.getValue());
        }
        for (Map.Entry optionEntry : this.serverGroup.transportChannelOptions.entrySet()) {
            serverBootstrap = (ServerBootstrap)serverBootstrap.option((ChannelOption)optionEntry.getKey(), optionEntry.getValue());
        }
        serverBootstrap.handler((ChannelHandler)new NewConnHandler());
        serverBootstrap.childHandler(channelInitializer);
        serverBootstrap.validate();
        LOG.info("Binding to : " + listenAddress);
        if (MANUAL_DISCOVERY_STATUS.get()) {
            this.serverStatusManager.localStatus(InstanceInfo.InstanceStatus.UP);
        }
        if ((alloc = (bindFuture = serverBootstrap.bind(listenAddress.unwrap())).channel().alloc()) instanceof ByteBufAllocatorMetricProvider) {
            ByteBufAllocatorMetric metrics = ((ByteBufAllocatorMetricProvider)alloc).metric();
            ((PolledMeter.Builder)PolledMeter.using((Registry)this.registry).withId(this.registry.createId("zuul.nettybuffermem.live", new String[]{"type", "heap"}))).monitorValue((Object)metrics, ByteBufAllocatorMetric::usedHeapMemory);
            ((PolledMeter.Builder)PolledMeter.using((Registry)this.registry).withId(this.registry.createId("zuul.nettybuffermem.live", new String[]{"type", "direct"}))).monitorValue((Object)metrics, ByteBufAllocatorMetric::usedDirectMemory);
        }
        try {
            return bindFuture.sync();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to bind on addr " + listenAddress, e);
        }
    }

    public void postEventLoopCreationHook(EventLoopGroup clientToProxyBossPool, EventLoopGroup clientToProxyWorkerPool) {
    }

    static Map<NamedSocketAddress, ChannelInitializer<?>> convertPortMap(Map<Integer, ChannelInitializer<?>> portsToChannelInitializers) {
        LinkedHashMap addrsToInitializers = new LinkedHashMap(portsToChannelInitializers.size());
        for (Map.Entry<Integer, ChannelInitializer<?>> portToInitializer : portsToChannelInitializers.entrySet()) {
            int portNumber = portToInitializer.getKey();
            addrsToInitializers.put(new NamedSocketAddress("port" + portNumber, new InetSocketAddress(portNumber)), portToInitializer.getValue());
        }
        return Collections.unmodifiableMap(addrsToInitializers);
    }

    private static boolean epollIsAvailable() {
        boolean available;
        try {
            available = Epoll.isAvailable();
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("Epoll is unavailable, skipping", (Throwable)e);
            return false;
        }
        catch (Error | RuntimeException e) {
            LOG.warn("Epoll is unavailable, skipping", e);
            return false;
        }
        if (!available) {
            LOG.debug("Epoll is unavailable, skipping", Epoll.unavailabilityCause());
        }
        return available;
    }

    private static boolean kqueueIsAvailable() {
        boolean available;
        try {
            available = KQueue.isAvailable();
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("KQueue is unavailable, skipping", (Throwable)e);
            return false;
        }
        catch (Error | RuntimeException e) {
            LOG.warn("KQueue is unavailable, skipping", e);
            return false;
        }
        if (!available) {
            LOG.debug("KQueue is unavailable, skipping", KQueue.unavailabilityCause());
        }
        return available;
    }

    private final class NewConnHandler
    extends ChannelInboundHandlerAdapter {
        private NewConnHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Long now = System.nanoTime();
            Channel child = (Channel)msg;
            child.attr(CONN_DIMENSIONS).set((Object)Attrs.newInstance());
            ConnTimer timer = ConnTimer.install(child, Server.this.registry, Server.this.registry.createId("zuul.conn.client.timing"));
            timer.record(now, "ACCEPT");
            ConnCounter.install(child, Server.this.registry, Server.this.registry.createId("zuul.conn.client.current"));
            super.channelRead(ctx, msg);
        }
    }

    private final class ServerGroup {
        private final String name;
        private final int acceptorThreads;
        private final int workerThreads;
        private final EventLoopGroupMetrics eventLoopGroupMetrics;
        private final Thread jvmShutdownHook = new Thread(this::stop, "Zuul-ServerGroup-JVM-shutdown-hook");
        private EventLoopGroup clientToProxyBossPool;
        private EventLoopGroup clientToProxyWorkerPool;
        private Class<? extends ServerChannel> channelType;
        private Map<ChannelOption<?>, ?> transportChannelOptions;
        private volatile boolean stopped = false;

        private ServerGroup(String name, int acceptorThreads, int workerThreads, EventLoopGroupMetrics eventLoopGroupMetrics) {
            this.name = name;
            this.acceptorThreads = acceptorThreads;
            this.workerThreads = workerThreads;
            this.eventLoopGroupMetrics = eventLoopGroupMetrics;
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.error("Uncaught throwable", e);
                }
            });
            Runtime.getRuntime().addShutdownHook(this.jvmShutdownHook);
        }

        private void initializeTransport() {
            Object chooserFactory = USE_LEASTCONNS_FOR_EVENTLOOPS.get() ? new LeastConnsEventLoopChooserFactory(this.eventLoopGroupMetrics) : DefaultEventExecutorChooserFactory.INSTANCE;
            CategorizedThreadFactory workerThreadFactory = new CategorizedThreadFactory(this.name + "-ClientToZuulWorker");
            ThreadPerTaskExecutor workerExecutor = new ThreadPerTaskExecutor((ThreadFactory)workerThreadFactory);
            HashMap<ChannelOption, Integer> extraOptions = new HashMap<ChannelOption, Integer>();
            boolean useNio = FORCE_NIO.get();
            if (!useNio && Server.epollIsAvailable()) {
                this.channelType = EpollServerSocketChannel.class;
                defaultOutboundChannelType.set(EpollSocketChannel.class);
                extraOptions.put(EpollChannelOption.TCP_DEFER_ACCEPT, -1);
                this.clientToProxyBossPool = new EpollEventLoopGroup(this.acceptorThreads, (ThreadFactory)new CategorizedThreadFactory(this.name + "-ClientToZuulAcceptor"));
                this.clientToProxyWorkerPool = new EpollEventLoopGroup(this.workerThreads, (Executor)workerExecutor, (EventExecutorChooserFactory)chooserFactory, DefaultSelectStrategyFactory.INSTANCE);
            } else if (!useNio && Server.kqueueIsAvailable()) {
                this.channelType = KQueueServerSocketChannel.class;
                defaultOutboundChannelType.set(KQueueSocketChannel.class);
                this.clientToProxyBossPool = new KQueueEventLoopGroup(this.acceptorThreads, (ThreadFactory)new CategorizedThreadFactory(this.name + "-ClientToZuulAcceptor"));
                this.clientToProxyWorkerPool = new KQueueEventLoopGroup(this.workerThreads, (Executor)workerExecutor, (EventExecutorChooserFactory)chooserFactory, DefaultSelectStrategyFactory.INSTANCE);
            } else {
                this.channelType = NioServerSocketChannel.class;
                defaultOutboundChannelType.set(NioSocketChannel.class);
                NioEventLoopGroup elg = new NioEventLoopGroup(this.workerThreads, (Executor)workerExecutor, (EventExecutorChooserFactory)chooserFactory, SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE);
                elg.setIoRatio(90);
                this.clientToProxyBossPool = new NioEventLoopGroup(this.acceptorThreads, (ThreadFactory)new CategorizedThreadFactory(this.name + "-ClientToZuulAcceptor"));
                this.clientToProxyWorkerPool = elg;
            }
            this.transportChannelOptions = Collections.unmodifiableMap(extraOptions);
            Server.this.postEventLoopCreationHook(this.clientToProxyBossPool, this.clientToProxyWorkerPool);
        }

        private synchronized void stop() {
            LOG.info("Shutting down");
            if (this.stopped) {
                LOG.info("Already stopped");
                return;
            }
            if (MANUAL_DISCOVERY_STATUS.get()) {
                Server.this.serverStatusManager.localStatus(InstanceInfo.InstanceStatus.DOWN);
            }
            Server.this.clientConnectionsShutdown.gracefullyShutdownClientChannels();
            LOG.info("Shutting down event loops");
            ArrayList<EventLoopGroup> allEventLoopGroups = new ArrayList<EventLoopGroup>();
            allEventLoopGroups.add(this.clientToProxyBossPool);
            allEventLoopGroups.add(this.clientToProxyWorkerPool);
            for (EventLoopGroup group : allEventLoopGroups) {
                group.shutdownGracefully();
            }
            for (EventLoopGroup group : allEventLoopGroups) {
                try {
                    group.awaitTermination(20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    LOG.warn("Interrupted while shutting down event loop");
                }
            }
            try {
                Runtime.getRuntime().removeShutdownHook(this.jvmShutdownHook);
            }
            catch (IllegalStateException e) {
                LOG.debug("Failed to remove shutdown hook", (Throwable)e);
            }
            this.stopped = true;
            LOG.info("Done shutting down");
        }
    }
}

