/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.zuul.exception.OutboundErrorType;
import com.netflix.zuul.exception.OutboundException;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.filters.endpoint.ProxyEndpoint;
import com.netflix.zuul.message.Header;
import com.netflix.zuul.message.http.HttpQueryParams;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.netty.connectionpool.OriginConnectException;
import com.netflix.zuul.passport.PassportState;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.perfmark.PerfMark;
import io.perfmark.TaskCloseable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginResponseReceiver
extends ChannelDuplexHandler {
    private volatile ProxyEndpoint edgeProxy;
    private static final Logger LOG = LoggerFactory.getLogger(OriginResponseReceiver.class);
    private static final AttributeKey<Throwable> SSL_HANDSHAKE_UNSUCCESS_FROM_ORIGIN_THROWABLE = AttributeKey.newInstance((String)"_ssl_handshake_from_origin_throwable");
    public static final String CHANNEL_HANDLER_NAME = "_origin_response_receiver";

    public OriginResponseReceiver(ProxyEndpoint edgeProxy) {
        this.edgeProxy = edgeProxy;
    }

    public void unlinkFromClientRequest() {
        this.edgeProxy = null;
    }

    public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try (TaskCloseable a = PerfMark.traceTask((String)"ORR.channelRead");){
            this.channelReadInternal(ctx, msg);
        }
    }

    private void channelReadInternal(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            if (this.edgeProxy != null) {
                this.edgeProxy.responseFromOrigin((HttpResponse)msg);
            }
            ctx.channel().read();
        } else if (msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            if (this.edgeProxy != null) {
                this.edgeProxy.invokeNext(chunk);
            } else {
                chunk.release();
            }
            ctx.channel().read();
        } else {
            ReferenceCountUtil.release((Object)msg);
            IllegalStateException error = new IllegalStateException("Received invalid message from origin");
            if (this.edgeProxy != null) {
                this.edgeProxy.errorFromOrigin(error);
            }
            ctx.fireExceptionCaught((Throwable)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
            HttpLifecycleChannelHandler.CompleteReason reason = ((HttpLifecycleChannelHandler.CompleteEvent)evt).getReason();
            if (reason != HttpLifecycleChannelHandler.CompleteReason.SESSION_COMPLETE && this.edgeProxy != null) {
                LOG.error("Origin request completed with reason other than COMPLETE: {}, {}", (Object)reason.name(), (Object)ChannelUtils.channelInfoForLogging(ctx.channel()));
                ZuulException ze = new ZuulException("CompleteEvent", reason.name(), true);
                this.edgeProxy.errorFromOrigin(ze);
            }
            try {
                super.userEventTriggered(ctx, evt);
            }
            finally {
                this.postCompleteHook(ctx, evt);
            }
        } else if (evt instanceof SslHandshakeCompletionEvent && !((SslHandshakeCompletionEvent)evt).isSuccess()) {
            Throwable cause = ((SslHandshakeCompletionEvent)evt).cause();
            ctx.channel().attr(SSL_HANDSHAKE_UNSUCCESS_FROM_ORIGIN_THROWABLE).set((Object)cause);
        } else if (evt instanceof IdleStateEvent) {
            if (this.edgeProxy != null) {
                LOG.error("Origin request received IDLE event: {}", (Object)ChannelUtils.channelInfoForLogging(ctx.channel()));
                this.edgeProxy.errorFromOrigin(new OutboundException(OutboundErrorType.READ_TIMEOUT, this.edgeProxy.getRequestAttempts()));
            }
            super.userEventTriggered(ctx, evt);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected void postCompleteHook(ChannelHandlerContext ctx, Object evt) throws Exception {
    }

    private HttpRequest buildOriginHttpRequest(HttpRequestMessage zuulRequest) {
        String method = zuulRequest.getMethod().toUpperCase();
        String uri = OriginResponseReceiver.pathAndQueryString(zuulRequest);
        this.customRequestProcessing(zuulRequest);
        DefaultHttpRequest nettyReq = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)method), uri, false);
        for (Header h : zuulRequest.getHeaders().entries()) {
            nettyReq.headers().add(h.getKey(), (Object)h.getValue());
        }
        return nettyReq;
    }

    protected void customRequestProcessing(HttpRequestMessage headers) {
    }

    private static String pathAndQueryString(HttpRequestMessage request) {
        HttpQueryParams cleanParams = HttpQueryParams.parse(request.getQueryParams().toEncodedString());
        String cleanQueryStr = cleanParams.toEncodedString();
        if (cleanQueryStr == null || cleanQueryStr.isEmpty()) {
            return request.getPath();
        }
        return request.getPath() + "?" + cleanParams.toEncodedString();
    }

    public final void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try (TaskCloseable ignore = PerfMark.traceTask((String)"ORR.writeInternal");){
            this.writeInternal(ctx, msg, promise);
        }
    }

    private void writeInternal(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!ctx.channel().isActive()) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        if (msg instanceof HttpRequestMessage) {
            promise.addListener(future -> {
                if (!future.isSuccess()) {
                    Throwable cause = (Throwable)ctx.channel().attr(SSL_HANDSHAKE_UNSUCCESS_FROM_ORIGIN_THROWABLE).get();
                    if (cause != null) {
                        ctx.channel().attr(SSL_HANDSHAKE_UNSUCCESS_FROM_ORIGIN_THROWABLE).set(null);
                        this.fireWriteError("request headers", cause, ctx);
                        LOG.debug("SSLException is overridden by SSLHandshakeException caught in handler level. Original SSL exception message: ", future.cause());
                    } else {
                        this.fireWriteError("request headers", future.cause(), ctx);
                    }
                }
            });
            HttpRequestMessage zuulReq = (HttpRequestMessage)msg;
            this.preWriteHook(ctx, zuulReq);
            super.write(ctx, (Object)this.buildOriginHttpRequest(zuulReq), promise);
        } else if (msg instanceof HttpContent) {
            promise.addListener(future -> {
                if (!future.isSuccess()) {
                    this.fireWriteError("request content chunk", future.cause(), ctx);
                }
            });
            super.write(ctx, msg, promise);
        } else {
            ReferenceCountUtil.release((Object)msg);
            throw new ZuulException("Received invalid message from client", true);
        }
    }

    protected void preWriteHook(ChannelHandlerContext ctx, HttpRequestMessage zuulReq) {
    }

    private void fireWriteError(String requestPart, Throwable cause, ChannelHandlerContext ctx) throws Exception {
        String errMesg = "Error while proxying " + requestPart + " to origin ";
        if (this.edgeProxy != null) {
            ProxyEndpoint ep = this.edgeProxy;
            this.edgeProxy = null;
            errMesg = errMesg + ep.getOrigin().getName();
            ep.errorFromOrigin(cause);
        }
        ctx.fireExceptionCaught((Throwable)new ZuulException(cause, errMesg, true));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.edgeProxy != null) {
            LOG.error("Error from Origin connection", cause);
            if (cause instanceof ReadTimeoutException) {
                this.edgeProxy.getPassport().add(PassportState.ORIGIN_CH_READ_TIMEOUT);
            } else if (cause instanceof IOException) {
                this.edgeProxy.getPassport().add(PassportState.ORIGIN_CH_IO_EX);
            }
            this.edgeProxy.errorFromOrigin(cause);
        }
        ctx.fireExceptionCaught(cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.edgeProxy != null) {
            LOG.debug("Origin channel inactive. channel-info={}", (Object)ChannelUtils.channelInfoForLogging(ctx.channel()));
            OriginConnectException ex = new OriginConnectException("Origin server inactive", OutboundErrorType.RESET_CONNECTION);
            this.edgeProxy.errorFromOrigin(ex);
        }
        super.channelInactive(ctx);
        ctx.close();
    }
}

