/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import java.net.SocketAddress;
import java.util.Objects;
import javax.annotation.CheckReturnValue;

public final class NamedSocketAddress
extends SocketAddress {
    private final String name;
    private final SocketAddress delegate;

    public NamedSocketAddress(String name, SocketAddress delegate) {
        this.name = Objects.requireNonNull(name);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public String name() {
        return this.name;
    }

    public SocketAddress unwrap() {
        return this.delegate;
    }

    @CheckReturnValue
    public NamedSocketAddress withNewSocket(SocketAddress delegate) {
        return new NamedSocketAddress(this.name, delegate);
    }

    public String toString() {
        return "NamedSocketAddress{name='" + this.name + '\'' + ", delegate=" + this.delegate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedSocketAddress that = (NamedSocketAddress)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.delegate);
    }
}

