/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.zuul.netty.server.BaseZuulChannelInitializer;
import com.netflix.zuul.netty.ssl.SslContextFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLException;

public class Http1MutualSslChannelInitializer
extends BaseZuulChannelInitializer {
    private final SslContextFactory sslContextFactory;
    private final SslContext sslContext;
    private final boolean isSSlFromIntermediary;

    @Deprecated
    public Http1MutualSslChannelInitializer(int port, ChannelConfig channelConfig, ChannelConfig channelDependencies, ChannelGroup channels) {
        this(String.valueOf(port), channelConfig, channelDependencies, channels);
    }

    public Http1MutualSslChannelInitializer(String metricId, ChannelConfig channelConfig, ChannelConfig channelDependencies, ChannelGroup channels) {
        super(metricId, channelConfig, channelDependencies, channels);
        this.isSSlFromIntermediary = channelConfig.get(CommonChannelConfigKeys.isSSlFromIntermediary);
        this.sslContextFactory = channelConfig.get(CommonChannelConfigKeys.sslContextFactory);
        try {
            this.sslContext = this.sslContextFactory.createBuilderForServer().build();
        }
        catch (SSLException e) {
            throw new RuntimeException("Error configuring SslContext!", e);
        }
        this.sslContextFactory.enableSessionTickets(this.sslContext);
        this.sslContextFactory.configureOpenSslStatsMetrics(this.sslContext, metricId);
    }

    protected void initChannel(Channel ch) throws Exception {
        SslHandler sslHandler = this.sslContext.newHandler(ch.alloc());
        sslHandler.engine().setEnabledProtocols(this.sslContextFactory.getProtocols());
        ChannelPipeline pipeline = ch.pipeline();
        this.storeChannel(ch);
        this.addTimeoutHandlers(pipeline);
        this.addPassportHandler(pipeline);
        this.addTcpRelatedHandlers(pipeline);
        pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        this.addSslInfoHandlers(pipeline, this.isSSlFromIntermediary);
        this.addSslClientCertChecks(pipeline);
        this.addHttp1Handlers(pipeline);
        this.addHttpRelatedHandlers(pipeline);
        this.addZuulHandlers(pipeline);
    }
}

