/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicIntProperty;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class DirectMemoryMonitor {
    private static final Logger LOG;
    private static final String PROP_PREFIX = "zuul.directmemory";
    private static final DynamicIntProperty TASK_DELAY_PROP;
    private static final Supplier<Long> directMemoryLimitGetter;
    private static final Supplier<Long> reservedMemoryGetter;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("dmm-%d").build());

    @Inject
    public DirectMemoryMonitor(Registry registry) {
        if (reservedMemoryGetter != null) {
            ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("zuul.directmemory.reserved")).withDelay(Duration.ofSeconds(TASK_DELAY_PROP.get())).scheduleOn(this.service).monitorValue(DirectMemoryMonitor.class, DirectMemoryMonitor::getReservedMemory);
        }
        if (directMemoryLimitGetter != null) {
            ((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("zuul.directmemory.max")).withDelay(Duration.ofSeconds(TASK_DELAY_PROP.get())).scheduleOn(this.service).monitorValue(DirectMemoryMonitor.class, DirectMemoryMonitor::getMaxMemory);
        }
    }

    private static double getReservedMemory(Object discard) {
        try {
            return reservedMemoryGetter.get().longValue();
        }
        catch (Error | RuntimeException e) {
            LOG.warn("Error in DirectMemoryMonitor task.", e);
            return -1.0;
        }
    }

    private static double getMaxMemory(Object discard) {
        try {
            return directMemoryLimitGetter.get().longValue();
        }
        catch (Error | RuntimeException e) {
            LOG.warn("Error in DirectMemoryMonitor task.", e);
            return -1.0;
        }
    }

    static {
        Supplier<Long> reservedMemory;
        Supplier<Long> directMemoryLimit;
        LOG = LoggerFactory.getLogger(DirectMemoryMonitor.class);
        TASK_DELAY_PROP = new DynamicIntProperty("zuul.directmemory.task.delay", 10);
        try {
            Class<?> c = Class.forName("io.netty.util.internal.PlatformDependent");
            Field directMemoryLimitField = c.getDeclaredField("DIRECT_MEMORY_LIMIT");
            directMemoryLimitField.setAccessible(true);
            directMemoryLimit = () -> {
                try {
                    return (long)((Long)directMemoryLimitField.get(null));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
            directMemoryLimit.get();
            Field reservedMemoryField = c.getDeclaredField("DIRECT_MEMORY_COUNTER");
            reservedMemoryField.setAccessible(true);
            reservedMemory = () -> {
                try {
                    AtomicLong value = (AtomicLong)reservedMemoryField.get(null);
                    return value == null ? -1L : value.get();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
            if (reservedMemory.get() == -1L) {
                LOG.debug("Unable to get direct memory");
            }
        }
        catch (Throwable t) {
            LOG.warn("Unable to query direct memory, disabling monitor", t);
            directMemoryLimit = null;
            reservedMemory = null;
        }
        directMemoryLimitGetter = directMemoryLimit;
        reservedMemoryGetter = reservedMemory;
    }
}

